/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.ColumnNameListCopier;
import software.amazon.awssdk.services.glue.model.ColumnStatisticsState;
import software.amazon.awssdk.services.glue.model.ComputationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ColumnStatisticsTaskRun
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ColumnStatisticsTaskRun> {
    private static final SdkField<String> CUSTOMER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomerId").getter(ColumnStatisticsTaskRun.getter(ColumnStatisticsTaskRun::customerId)).setter(ColumnStatisticsTaskRun.setter(Builder::customerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerId").build()}).build();
    private static final SdkField<String> COLUMN_STATISTICS_TASK_RUN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ColumnStatisticsTaskRunId").getter(ColumnStatisticsTaskRun.getter(ColumnStatisticsTaskRun::columnStatisticsTaskRunId)).setter(ColumnStatisticsTaskRun.setter(Builder::columnStatisticsTaskRunId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnStatisticsTaskRunId").build()}).build();
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseName").getter(ColumnStatisticsTaskRun.getter(ColumnStatisticsTaskRun::databaseName)).setter(ColumnStatisticsTaskRun.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()}).build();
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableName").getter(ColumnStatisticsTaskRun.getter(ColumnStatisticsTaskRun::tableName)).setter(ColumnStatisticsTaskRun.setter(Builder::tableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()}).build();
    private static final SdkField<List<String>> COLUMN_NAME_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ColumnNameList").getter(ColumnStatisticsTaskRun.getter(ColumnStatisticsTaskRun::columnNameList)).setter(ColumnStatisticsTaskRun.setter(Builder::columnNameList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnNameList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CatalogID").getter(ColumnStatisticsTaskRun.getter(ColumnStatisticsTaskRun::catalogID)).setter(ColumnStatisticsTaskRun.setter(Builder::catalogID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogID").build()}).build();
    private static final SdkField<String> ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Role").getter(ColumnStatisticsTaskRun.getter(ColumnStatisticsTaskRun::role)).setter(ColumnStatisticsTaskRun.setter(Builder::role)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()}).build();
    private static final SdkField<Double> SAMPLE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("SampleSize").getter(ColumnStatisticsTaskRun.getter(ColumnStatisticsTaskRun::sampleSize)).setter(ColumnStatisticsTaskRun.setter(Builder::sampleSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SampleSize").build()}).build();
    private static final SdkField<String> SECURITY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecurityConfiguration").getter(ColumnStatisticsTaskRun.getter(ColumnStatisticsTaskRun::securityConfiguration)).setter(ColumnStatisticsTaskRun.setter(Builder::securityConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityConfiguration").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_WORKERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfWorkers").getter(ColumnStatisticsTaskRun.getter(ColumnStatisticsTaskRun::numberOfWorkers)).setter(ColumnStatisticsTaskRun.setter(Builder::numberOfWorkers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfWorkers").build()}).build();
    private static final SdkField<String> WORKER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkerType").getter(ColumnStatisticsTaskRun.getter(ColumnStatisticsTaskRun::workerType)).setter(ColumnStatisticsTaskRun.setter(Builder::workerType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkerType").build()}).build();
    private static final SdkField<String> COMPUTATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComputationType").getter(ColumnStatisticsTaskRun.getter(ColumnStatisticsTaskRun::computationTypeAsString)).setter(ColumnStatisticsTaskRun.setter(Builder::computationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputationType").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ColumnStatisticsTaskRun.getter(ColumnStatisticsTaskRun::statusAsString)).setter(ColumnStatisticsTaskRun.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(ColumnStatisticsTaskRun.getter(ColumnStatisticsTaskRun::creationTime)).setter(ColumnStatisticsTaskRun.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdated").getter(ColumnStatisticsTaskRun.getter(ColumnStatisticsTaskRun::lastUpdated)).setter(ColumnStatisticsTaskRun.setter(Builder::lastUpdated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdated").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(ColumnStatisticsTaskRun.getter(ColumnStatisticsTaskRun::startTime)).setter(ColumnStatisticsTaskRun.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(ColumnStatisticsTaskRun.getter(ColumnStatisticsTaskRun::endTime)).setter(ColumnStatisticsTaskRun.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorMessage").getter(ColumnStatisticsTaskRun.getter(ColumnStatisticsTaskRun::errorMessage)).setter(ColumnStatisticsTaskRun.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()}).build();
    private static final SdkField<Double> DPU_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("DPUSeconds").getter(ColumnStatisticsTaskRun.getter(ColumnStatisticsTaskRun::dpuSeconds)).setter(ColumnStatisticsTaskRun.setter(Builder::dpuSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DPUSeconds").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOMER_ID_FIELD, COLUMN_STATISTICS_TASK_RUN_ID_FIELD, DATABASE_NAME_FIELD, TABLE_NAME_FIELD, COLUMN_NAME_LIST_FIELD, CATALOG_ID_FIELD, ROLE_FIELD, SAMPLE_SIZE_FIELD, SECURITY_CONFIGURATION_FIELD, NUMBER_OF_WORKERS_FIELD, WORKER_TYPE_FIELD, COMPUTATION_TYPE_FIELD, STATUS_FIELD, CREATION_TIME_FIELD, LAST_UPDATED_FIELD, START_TIME_FIELD, END_TIME_FIELD, ERROR_MESSAGE_FIELD, DPU_SECONDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("CustomerId", CUSTOMER_ID_FIELD);
            this.put("ColumnStatisticsTaskRunId", COLUMN_STATISTICS_TASK_RUN_ID_FIELD);
            this.put("DatabaseName", DATABASE_NAME_FIELD);
            this.put("TableName", TABLE_NAME_FIELD);
            this.put("ColumnNameList", COLUMN_NAME_LIST_FIELD);
            this.put("CatalogID", CATALOG_ID_FIELD);
            this.put("Role", ROLE_FIELD);
            this.put("SampleSize", SAMPLE_SIZE_FIELD);
            this.put("SecurityConfiguration", SECURITY_CONFIGURATION_FIELD);
            this.put("NumberOfWorkers", NUMBER_OF_WORKERS_FIELD);
            this.put("WorkerType", WORKER_TYPE_FIELD);
            this.put("ComputationType", COMPUTATION_TYPE_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("CreationTime", CREATION_TIME_FIELD);
            this.put("LastUpdated", LAST_UPDATED_FIELD);
            this.put("StartTime", START_TIME_FIELD);
            this.put("EndTime", END_TIME_FIELD);
            this.put("ErrorMessage", ERROR_MESSAGE_FIELD);
            this.put("DPUSeconds", DPU_SECONDS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String customerId;
    private final String columnStatisticsTaskRunId;
    private final String databaseName;
    private final String tableName;
    private final List<String> columnNameList;
    private final String catalogID;
    private final String role;
    private final Double sampleSize;
    private final String securityConfiguration;
    private final Integer numberOfWorkers;
    private final String workerType;
    private final String computationType;
    private final String status;
    private final Instant creationTime;
    private final Instant lastUpdated;
    private final Instant startTime;
    private final Instant endTime;
    private final String errorMessage;
    private final Double dpuSeconds;

    private ColumnStatisticsTaskRun(BuilderImpl builder) {
        this.customerId = builder.customerId;
        this.columnStatisticsTaskRunId = builder.columnStatisticsTaskRunId;
        this.databaseName = builder.databaseName;
        this.tableName = builder.tableName;
        this.columnNameList = builder.columnNameList;
        this.catalogID = builder.catalogID;
        this.role = builder.role;
        this.sampleSize = builder.sampleSize;
        this.securityConfiguration = builder.securityConfiguration;
        this.numberOfWorkers = builder.numberOfWorkers;
        this.workerType = builder.workerType;
        this.computationType = builder.computationType;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
        this.lastUpdated = builder.lastUpdated;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.errorMessage = builder.errorMessage;
        this.dpuSeconds = builder.dpuSeconds;
    }

    public final String customerId() {
        return this.customerId;
    }

    public final String columnStatisticsTaskRunId() {
        return this.columnStatisticsTaskRunId;
    }

    public final String databaseName() {
        return this.databaseName;
    }

    public final String tableName() {
        return this.tableName;
    }

    public final boolean hasColumnNameList() {
        return this.columnNameList != null && !(this.columnNameList instanceof SdkAutoConstructList);
    }

    public final List<String> columnNameList() {
        return this.columnNameList;
    }

    public final String catalogID() {
        return this.catalogID;
    }

    public final String role() {
        return this.role;
    }

    public final Double sampleSize() {
        return this.sampleSize;
    }

    public final String securityConfiguration() {
        return this.securityConfiguration;
    }

    public final Integer numberOfWorkers() {
        return this.numberOfWorkers;
    }

    public final String workerType() {
        return this.workerType;
    }

    public final ComputationType computationType() {
        return ComputationType.fromValue(this.computationType);
    }

    public final String computationTypeAsString() {
        return this.computationType;
    }

    public final ColumnStatisticsState status() {
        return ColumnStatisticsState.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastUpdated() {
        return this.lastUpdated;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public final Double dpuSeconds() {
        return this.dpuSeconds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.customerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.columnStatisticsTaskRunId());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasColumnNameList() ? this.columnNameList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogID());
        hashCode = 31 * hashCode + Objects.hashCode(this.role());
        hashCode = 31 * hashCode + Objects.hashCode(this.sampleSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfWorkers());
        hashCode = 31 * hashCode + Objects.hashCode(this.workerType());
        hashCode = 31 * hashCode + Objects.hashCode(this.computationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.dpuSeconds());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ColumnStatisticsTaskRun)) {
            return false;
        }
        ColumnStatisticsTaskRun other = (ColumnStatisticsTaskRun)obj;
        return Objects.equals(this.customerId(), other.customerId()) && Objects.equals(this.columnStatisticsTaskRunId(), other.columnStatisticsTaskRunId()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.tableName(), other.tableName()) && this.hasColumnNameList() == other.hasColumnNameList() && Objects.equals(this.columnNameList(), other.columnNameList()) && Objects.equals(this.catalogID(), other.catalogID()) && Objects.equals(this.role(), other.role()) && Objects.equals(this.sampleSize(), other.sampleSize()) && Objects.equals(this.securityConfiguration(), other.securityConfiguration()) && Objects.equals(this.numberOfWorkers(), other.numberOfWorkers()) && Objects.equals(this.workerType(), other.workerType()) && Objects.equals(this.computationTypeAsString(), other.computationTypeAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastUpdated(), other.lastUpdated()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.dpuSeconds(), other.dpuSeconds());
    }

    public final String toString() {
        return ToString.builder((String)"ColumnStatisticsTaskRun").add("CustomerId", (Object)this.customerId()).add("ColumnStatisticsTaskRunId", (Object)this.columnStatisticsTaskRunId()).add("DatabaseName", (Object)this.databaseName()).add("TableName", (Object)this.tableName()).add("ColumnNameList", this.hasColumnNameList() ? this.columnNameList() : null).add("CatalogID", (Object)this.catalogID()).add("Role", (Object)this.role()).add("SampleSize", (Object)this.sampleSize()).add("SecurityConfiguration", (Object)this.securityConfiguration()).add("NumberOfWorkers", (Object)this.numberOfWorkers()).add("WorkerType", (Object)this.workerType()).add("ComputationType", (Object)this.computationTypeAsString()).add("Status", (Object)this.statusAsString()).add("CreationTime", (Object)this.creationTime()).add("LastUpdated", (Object)this.lastUpdated()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("ErrorMessage", (Object)this.errorMessage()).add("DPUSeconds", (Object)this.dpuSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CustomerId": {
                return Optional.ofNullable(clazz.cast(this.customerId()));
            }
            case "ColumnStatisticsTaskRunId": {
                return Optional.ofNullable(clazz.cast(this.columnStatisticsTaskRunId()));
            }
            case "DatabaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "TableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "ColumnNameList": {
                return Optional.ofNullable(clazz.cast(this.columnNameList()));
            }
            case "CatalogID": {
                return Optional.ofNullable(clazz.cast(this.catalogID()));
            }
            case "Role": {
                return Optional.ofNullable(clazz.cast(this.role()));
            }
            case "SampleSize": {
                return Optional.ofNullable(clazz.cast(this.sampleSize()));
            }
            case "SecurityConfiguration": {
                return Optional.ofNullable(clazz.cast(this.securityConfiguration()));
            }
            case "NumberOfWorkers": {
                return Optional.ofNullable(clazz.cast(this.numberOfWorkers()));
            }
            case "WorkerType": {
                return Optional.ofNullable(clazz.cast(this.workerType()));
            }
            case "ComputationType": {
                return Optional.ofNullable(clazz.cast(this.computationTypeAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastUpdated": {
                return Optional.ofNullable(clazz.cast(this.lastUpdated()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "ErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "DPUSeconds": {
                return Optional.ofNullable(clazz.cast(this.dpuSeconds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ColumnStatisticsTaskRun, T> g) {
        return obj -> g.apply((ColumnStatisticsTaskRun)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String customerId;
        private String columnStatisticsTaskRunId;
        private String databaseName;
        private String tableName;
        private List<String> columnNameList = DefaultSdkAutoConstructList.getInstance();
        private String catalogID;
        private String role;
        private Double sampleSize;
        private String securityConfiguration;
        private Integer numberOfWorkers;
        private String workerType;
        private String computationType;
        private String status;
        private Instant creationTime;
        private Instant lastUpdated;
        private Instant startTime;
        private Instant endTime;
        private String errorMessage;
        private Double dpuSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(ColumnStatisticsTaskRun model) {
            this.customerId(model.customerId);
            this.columnStatisticsTaskRunId(model.columnStatisticsTaskRunId);
            this.databaseName(model.databaseName);
            this.tableName(model.tableName);
            this.columnNameList(model.columnNameList);
            this.catalogID(model.catalogID);
            this.role(model.role);
            this.sampleSize(model.sampleSize);
            this.securityConfiguration(model.securityConfiguration);
            this.numberOfWorkers(model.numberOfWorkers);
            this.workerType(model.workerType);
            this.computationType(model.computationType);
            this.status(model.status);
            this.creationTime(model.creationTime);
            this.lastUpdated(model.lastUpdated);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.errorMessage(model.errorMessage);
            this.dpuSeconds(model.dpuSeconds);
        }

        public final String getCustomerId() {
            return this.customerId;
        }

        public final void setCustomerId(String customerId) {
            this.customerId = customerId;
        }

        @Override
        public final Builder customerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public final String getColumnStatisticsTaskRunId() {
            return this.columnStatisticsTaskRunId;
        }

        public final void setColumnStatisticsTaskRunId(String columnStatisticsTaskRunId) {
            this.columnStatisticsTaskRunId = columnStatisticsTaskRunId;
        }

        @Override
        public final Builder columnStatisticsTaskRunId(String columnStatisticsTaskRunId) {
            this.columnStatisticsTaskRunId = columnStatisticsTaskRunId;
            return this;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getTableName() {
            return this.tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final Collection<String> getColumnNameList() {
            if (this.columnNameList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.columnNameList;
        }

        public final void setColumnNameList(Collection<String> columnNameList) {
            this.columnNameList = ColumnNameListCopier.copy(columnNameList);
        }

        @Override
        public final Builder columnNameList(Collection<String> columnNameList) {
            this.columnNameList = ColumnNameListCopier.copy(columnNameList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnNameList(String ... columnNameList) {
            this.columnNameList(Arrays.asList(columnNameList));
            return this;
        }

        public final String getCatalogID() {
            return this.catalogID;
        }

        public final void setCatalogID(String catalogID) {
            this.catalogID = catalogID;
        }

        @Override
        public final Builder catalogID(String catalogID) {
            this.catalogID = catalogID;
            return this;
        }

        public final String getRole() {
            return this.role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final Double getSampleSize() {
            return this.sampleSize;
        }

        public final void setSampleSize(Double sampleSize) {
            this.sampleSize = sampleSize;
        }

        @Override
        public final Builder sampleSize(Double sampleSize) {
            this.sampleSize = sampleSize;
            return this;
        }

        public final String getSecurityConfiguration() {
            return this.securityConfiguration;
        }

        public final void setSecurityConfiguration(String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
        }

        @Override
        public final Builder securityConfiguration(String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
            return this;
        }

        public final Integer getNumberOfWorkers() {
            return this.numberOfWorkers;
        }

        public final void setNumberOfWorkers(Integer numberOfWorkers) {
            this.numberOfWorkers = numberOfWorkers;
        }

        @Override
        public final Builder numberOfWorkers(Integer numberOfWorkers) {
            this.numberOfWorkers = numberOfWorkers;
            return this;
        }

        public final String getWorkerType() {
            return this.workerType;
        }

        public final void setWorkerType(String workerType) {
            this.workerType = workerType;
        }

        @Override
        public final Builder workerType(String workerType) {
            this.workerType = workerType;
            return this;
        }

        public final String getComputationType() {
            return this.computationType;
        }

        public final void setComputationType(String computationType) {
            this.computationType = computationType;
        }

        @Override
        public final Builder computationType(String computationType) {
            this.computationType = computationType;
            return this;
        }

        @Override
        public final Builder computationType(ComputationType computationType) {
            this.computationType(computationType == null ? null : computationType.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ColumnStatisticsState status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastUpdated() {
            return this.lastUpdated;
        }

        public final void setLastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
        }

        @Override
        public final Builder lastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final Double getDpuSeconds() {
            return this.dpuSeconds;
        }

        public final void setDpuSeconds(Double dpuSeconds) {
            this.dpuSeconds = dpuSeconds;
        }

        @Override
        public final Builder dpuSeconds(Double dpuSeconds) {
            this.dpuSeconds = dpuSeconds;
            return this;
        }

        public ColumnStatisticsTaskRun build() {
            return new ColumnStatisticsTaskRun(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ColumnStatisticsTaskRun> {
        public Builder customerId(String var1);

        public Builder columnStatisticsTaskRunId(String var1);

        public Builder databaseName(String var1);

        public Builder tableName(String var1);

        public Builder columnNameList(Collection<String> var1);

        public Builder columnNameList(String ... var1);

        public Builder catalogID(String var1);

        public Builder role(String var1);

        public Builder sampleSize(Double var1);

        public Builder securityConfiguration(String var1);

        public Builder numberOfWorkers(Integer var1);

        public Builder workerType(String var1);

        public Builder computationType(String var1);

        public Builder computationType(ComputationType var1);

        public Builder status(String var1);

        public Builder status(ColumnStatisticsState var1);

        public Builder creationTime(Instant var1);

        public Builder lastUpdated(Instant var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder errorMessage(String var1);

        public Builder dpuSeconds(Double var1);
    }
}

