/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.DataQualityMetricValues;
import software.amazon.awssdk.services.glue.model.NewRulesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MetricBasedObservation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MetricBasedObservation> {
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetricName").getter(MetricBasedObservation.getter(MetricBasedObservation::metricName)).setter(MetricBasedObservation.setter(Builder::metricName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricName").build()}).build();
    private static final SdkField<String> STATISTIC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatisticId").getter(MetricBasedObservation.getter(MetricBasedObservation::statisticId)).setter(MetricBasedObservation.setter(Builder::statisticId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatisticId").build()}).build();
    private static final SdkField<DataQualityMetricValues> METRIC_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MetricValues").getter(MetricBasedObservation.getter(MetricBasedObservation::metricValues)).setter(MetricBasedObservation.setter(Builder::metricValues)).constructor(DataQualityMetricValues::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricValues").build()}).build();
    private static final SdkField<List<String>> NEW_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NewRules").getter(MetricBasedObservation.getter(MetricBasedObservation::newRules)).setter(MetricBasedObservation.setter(Builder::newRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_NAME_FIELD, STATISTIC_ID_FIELD, METRIC_VALUES_FIELD, NEW_RULES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String metricName;
    private final String statisticId;
    private final DataQualityMetricValues metricValues;
    private final List<String> newRules;

    private MetricBasedObservation(BuilderImpl builder) {
        this.metricName = builder.metricName;
        this.statisticId = builder.statisticId;
        this.metricValues = builder.metricValues;
        this.newRules = builder.newRules;
    }

    public final String metricName() {
        return this.metricName;
    }

    public final String statisticId() {
        return this.statisticId;
    }

    public final DataQualityMetricValues metricValues() {
        return this.metricValues;
    }

    public final boolean hasNewRules() {
        return this.newRules != null && !(this.newRules instanceof SdkAutoConstructList);
    }

    public final List<String> newRules() {
        return this.newRules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.metricName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statisticId());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricValues());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNewRules() ? this.newRules() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricBasedObservation)) {
            return false;
        }
        MetricBasedObservation other = (MetricBasedObservation)obj;
        return Objects.equals(this.metricName(), other.metricName()) && Objects.equals(this.statisticId(), other.statisticId()) && Objects.equals(this.metricValues(), other.metricValues()) && this.hasNewRules() == other.hasNewRules() && Objects.equals(this.newRules(), other.newRules());
    }

    public final String toString() {
        return ToString.builder((String)"MetricBasedObservation").add("MetricName", (Object)this.metricName()).add("StatisticId", (Object)this.statisticId()).add("MetricValues", (Object)this.metricValues()).add("NewRules", this.hasNewRules() ? this.newRules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MetricName": {
                return Optional.ofNullable(clazz.cast(this.metricName()));
            }
            case "StatisticId": {
                return Optional.ofNullable(clazz.cast(this.statisticId()));
            }
            case "MetricValues": {
                return Optional.ofNullable(clazz.cast(this.metricValues()));
            }
            case "NewRules": {
                return Optional.ofNullable(clazz.cast(this.newRules()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MetricBasedObservation, T> g) {
        return obj -> g.apply((MetricBasedObservation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String metricName;
        private String statisticId;
        private DataQualityMetricValues metricValues;
        private List<String> newRules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MetricBasedObservation model) {
            this.metricName(model.metricName);
            this.statisticId(model.statisticId);
            this.metricValues(model.metricValues);
            this.newRules(model.newRules);
        }

        public final String getMetricName() {
            return this.metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final String getStatisticId() {
            return this.statisticId;
        }

        public final void setStatisticId(String statisticId) {
            this.statisticId = statisticId;
        }

        @Override
        public final Builder statisticId(String statisticId) {
            this.statisticId = statisticId;
            return this;
        }

        public final DataQualityMetricValues.Builder getMetricValues() {
            return this.metricValues != null ? this.metricValues.toBuilder() : null;
        }

        public final void setMetricValues(DataQualityMetricValues.BuilderImpl metricValues) {
            this.metricValues = metricValues != null ? metricValues.build() : null;
        }

        @Override
        public final Builder metricValues(DataQualityMetricValues metricValues) {
            this.metricValues = metricValues;
            return this;
        }

        public final Collection<String> getNewRules() {
            if (this.newRules instanceof SdkAutoConstructList) {
                return null;
            }
            return this.newRules;
        }

        public final void setNewRules(Collection<String> newRules) {
            this.newRules = NewRulesCopier.copy(newRules);
        }

        @Override
        public final Builder newRules(Collection<String> newRules) {
            this.newRules = NewRulesCopier.copy(newRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder newRules(String ... newRules) {
            this.newRules(Arrays.asList(newRules));
            return this;
        }

        public MetricBasedObservation build() {
            return new MetricBasedObservation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MetricBasedObservation> {
        public Builder metricName(String var1);

        public Builder statisticId(String var1);

        public Builder metricValues(DataQualityMetricValues var1);

        default public Builder metricValues(Consumer<DataQualityMetricValues.Builder> metricValues) {
            return this.metricValues((DataQualityMetricValues)((DataQualityMetricValues.Builder)DataQualityMetricValues.builder().applyMutation(metricValues)).build());
        }

        public Builder newRules(Collection<String> var1);

        public Builder newRules(String ... var1);
    }
}

