/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.CompactionMetrics;
import software.amazon.awssdk.services.glue.model.OrphanFileDeletionMetrics;
import software.amazon.awssdk.services.glue.model.RetentionMetrics;
import software.amazon.awssdk.services.glue.model.RunMetrics;
import software.amazon.awssdk.services.glue.model.TableOptimizerEventType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TableOptimizerRun
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TableOptimizerRun> {
    private static final SdkField<String> EVENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventType").getter(TableOptimizerRun.getter(TableOptimizerRun::eventTypeAsString)).setter(TableOptimizerRun.setter(Builder::eventType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventType").build()}).build();
    private static final SdkField<Instant> START_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTimestamp").getter(TableOptimizerRun.getter(TableOptimizerRun::startTimestamp)).setter(TableOptimizerRun.setter(Builder::startTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTimestamp").build()}).build();
    private static final SdkField<Instant> END_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTimestamp").getter(TableOptimizerRun.getter(TableOptimizerRun::endTimestamp)).setter(TableOptimizerRun.setter(Builder::endTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTimestamp").build()}).build();
    private static final SdkField<RunMetrics> METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("metrics").getter(TableOptimizerRun.getter(TableOptimizerRun::metrics)).setter(TableOptimizerRun.setter(Builder::metrics)).constructor(RunMetrics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metrics").build()}).build();
    private static final SdkField<String> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("error").getter(TableOptimizerRun.getter(TableOptimizerRun::error)).setter(TableOptimizerRun.setter(Builder::error)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()}).build();
    private static final SdkField<CompactionMetrics> COMPACTION_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("compactionMetrics").getter(TableOptimizerRun.getter(TableOptimizerRun::compactionMetrics)).setter(TableOptimizerRun.setter(Builder::compactionMetrics)).constructor(CompactionMetrics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("compactionMetrics").build()}).build();
    private static final SdkField<RetentionMetrics> RETENTION_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("retentionMetrics").getter(TableOptimizerRun.getter(TableOptimizerRun::retentionMetrics)).setter(TableOptimizerRun.setter(Builder::retentionMetrics)).constructor(RetentionMetrics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retentionMetrics").build()}).build();
    private static final SdkField<OrphanFileDeletionMetrics> ORPHAN_FILE_DELETION_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("orphanFileDeletionMetrics").getter(TableOptimizerRun.getter(TableOptimizerRun::orphanFileDeletionMetrics)).setter(TableOptimizerRun.setter(Builder::orphanFileDeletionMetrics)).constructor(OrphanFileDeletionMetrics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orphanFileDeletionMetrics").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_TYPE_FIELD, START_TIMESTAMP_FIELD, END_TIMESTAMP_FIELD, METRICS_FIELD, ERROR_FIELD, COMPACTION_METRICS_FIELD, RETENTION_METRICS_FIELD, ORPHAN_FILE_DELETION_METRICS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("eventType", EVENT_TYPE_FIELD);
            this.put("startTimestamp", START_TIMESTAMP_FIELD);
            this.put("endTimestamp", END_TIMESTAMP_FIELD);
            this.put("metrics", METRICS_FIELD);
            this.put("error", ERROR_FIELD);
            this.put("compactionMetrics", COMPACTION_METRICS_FIELD);
            this.put("retentionMetrics", RETENTION_METRICS_FIELD);
            this.put("orphanFileDeletionMetrics", ORPHAN_FILE_DELETION_METRICS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String eventType;
    private final Instant startTimestamp;
    private final Instant endTimestamp;
    private final RunMetrics metrics;
    private final String error;
    private final CompactionMetrics compactionMetrics;
    private final RetentionMetrics retentionMetrics;
    private final OrphanFileDeletionMetrics orphanFileDeletionMetrics;

    private TableOptimizerRun(BuilderImpl builder) {
        this.eventType = builder.eventType;
        this.startTimestamp = builder.startTimestamp;
        this.endTimestamp = builder.endTimestamp;
        this.metrics = builder.metrics;
        this.error = builder.error;
        this.compactionMetrics = builder.compactionMetrics;
        this.retentionMetrics = builder.retentionMetrics;
        this.orphanFileDeletionMetrics = builder.orphanFileDeletionMetrics;
    }

    public final TableOptimizerEventType eventType() {
        return TableOptimizerEventType.fromValue(this.eventType);
    }

    public final String eventTypeAsString() {
        return this.eventType;
    }

    public final Instant startTimestamp() {
        return this.startTimestamp;
    }

    public final Instant endTimestamp() {
        return this.endTimestamp;
    }

    @Deprecated
    public final RunMetrics metrics() {
        return this.metrics;
    }

    public final String error() {
        return this.error;
    }

    public final CompactionMetrics compactionMetrics() {
        return this.compactionMetrics;
    }

    public final RetentionMetrics retentionMetrics() {
        return this.retentionMetrics;
    }

    public final OrphanFileDeletionMetrics orphanFileDeletionMetrics() {
        return this.orphanFileDeletionMetrics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.metrics());
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        hashCode = 31 * hashCode + Objects.hashCode(this.compactionMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(this.retentionMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(this.orphanFileDeletionMetrics());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableOptimizerRun)) {
            return false;
        }
        TableOptimizerRun other = (TableOptimizerRun)obj;
        return Objects.equals(this.eventTypeAsString(), other.eventTypeAsString()) && Objects.equals(this.startTimestamp(), other.startTimestamp()) && Objects.equals(this.endTimestamp(), other.endTimestamp()) && Objects.equals(this.metrics(), other.metrics()) && Objects.equals(this.error(), other.error()) && Objects.equals(this.compactionMetrics(), other.compactionMetrics()) && Objects.equals(this.retentionMetrics(), other.retentionMetrics()) && Objects.equals(this.orphanFileDeletionMetrics(), other.orphanFileDeletionMetrics());
    }

    public final String toString() {
        return ToString.builder((String)"TableOptimizerRun").add("EventType", (Object)this.eventTypeAsString()).add("StartTimestamp", (Object)this.startTimestamp()).add("EndTimestamp", (Object)this.endTimestamp()).add("Metrics", (Object)this.metrics()).add("Error", (Object)this.error()).add("CompactionMetrics", (Object)this.compactionMetrics()).add("RetentionMetrics", (Object)this.retentionMetrics()).add("OrphanFileDeletionMetrics", (Object)this.orphanFileDeletionMetrics()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eventType": {
                return Optional.ofNullable(clazz.cast(this.eventTypeAsString()));
            }
            case "startTimestamp": {
                return Optional.ofNullable(clazz.cast(this.startTimestamp()));
            }
            case "endTimestamp": {
                return Optional.ofNullable(clazz.cast(this.endTimestamp()));
            }
            case "metrics": {
                return Optional.ofNullable(clazz.cast(this.metrics()));
            }
            case "error": {
                return Optional.ofNullable(clazz.cast(this.error()));
            }
            case "compactionMetrics": {
                return Optional.ofNullable(clazz.cast(this.compactionMetrics()));
            }
            case "retentionMetrics": {
                return Optional.ofNullable(clazz.cast(this.retentionMetrics()));
            }
            case "orphanFileDeletionMetrics": {
                return Optional.ofNullable(clazz.cast(this.orphanFileDeletionMetrics()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TableOptimizerRun, T> g) {
        return obj -> g.apply((TableOptimizerRun)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String eventType;
        private Instant startTimestamp;
        private Instant endTimestamp;
        private RunMetrics metrics;
        private String error;
        private CompactionMetrics compactionMetrics;
        private RetentionMetrics retentionMetrics;
        private OrphanFileDeletionMetrics orphanFileDeletionMetrics;

        private BuilderImpl() {
        }

        private BuilderImpl(TableOptimizerRun model) {
            this.eventType(model.eventType);
            this.startTimestamp(model.startTimestamp);
            this.endTimestamp(model.endTimestamp);
            this.metrics(model.metrics);
            this.error(model.error);
            this.compactionMetrics(model.compactionMetrics);
            this.retentionMetrics(model.retentionMetrics);
            this.orphanFileDeletionMetrics(model.orphanFileDeletionMetrics);
        }

        public final String getEventType() {
            return this.eventType;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        @Override
        public final Builder eventType(TableOptimizerEventType eventType) {
            this.eventType(eventType == null ? null : eventType.toString());
            return this;
        }

        public final Instant getStartTimestamp() {
            return this.startTimestamp;
        }

        public final void setStartTimestamp(Instant startTimestamp) {
            this.startTimestamp = startTimestamp;
        }

        @Override
        public final Builder startTimestamp(Instant startTimestamp) {
            this.startTimestamp = startTimestamp;
            return this;
        }

        public final Instant getEndTimestamp() {
            return this.endTimestamp;
        }

        public final void setEndTimestamp(Instant endTimestamp) {
            this.endTimestamp = endTimestamp;
        }

        @Override
        public final Builder endTimestamp(Instant endTimestamp) {
            this.endTimestamp = endTimestamp;
            return this;
        }

        @Deprecated
        public final RunMetrics.Builder getMetrics() {
            return this.metrics != null ? this.metrics.toBuilder() : null;
        }

        @Deprecated
        public final void setMetrics(RunMetrics.BuilderImpl metrics) {
            this.metrics = metrics != null ? metrics.build() : null;
        }

        @Override
        @Deprecated
        public final Builder metrics(RunMetrics metrics) {
            this.metrics = metrics;
            return this;
        }

        public final String getError() {
            return this.error;
        }

        public final void setError(String error) {
            this.error = error;
        }

        @Override
        public final Builder error(String error) {
            this.error = error;
            return this;
        }

        public final CompactionMetrics.Builder getCompactionMetrics() {
            return this.compactionMetrics != null ? this.compactionMetrics.toBuilder() : null;
        }

        public final void setCompactionMetrics(CompactionMetrics.BuilderImpl compactionMetrics) {
            this.compactionMetrics = compactionMetrics != null ? compactionMetrics.build() : null;
        }

        @Override
        public final Builder compactionMetrics(CompactionMetrics compactionMetrics) {
            this.compactionMetrics = compactionMetrics;
            return this;
        }

        public final RetentionMetrics.Builder getRetentionMetrics() {
            return this.retentionMetrics != null ? this.retentionMetrics.toBuilder() : null;
        }

        public final void setRetentionMetrics(RetentionMetrics.BuilderImpl retentionMetrics) {
            this.retentionMetrics = retentionMetrics != null ? retentionMetrics.build() : null;
        }

        @Override
        public final Builder retentionMetrics(RetentionMetrics retentionMetrics) {
            this.retentionMetrics = retentionMetrics;
            return this;
        }

        public final OrphanFileDeletionMetrics.Builder getOrphanFileDeletionMetrics() {
            return this.orphanFileDeletionMetrics != null ? this.orphanFileDeletionMetrics.toBuilder() : null;
        }

        public final void setOrphanFileDeletionMetrics(OrphanFileDeletionMetrics.BuilderImpl orphanFileDeletionMetrics) {
            this.orphanFileDeletionMetrics = orphanFileDeletionMetrics != null ? orphanFileDeletionMetrics.build() : null;
        }

        @Override
        public final Builder orphanFileDeletionMetrics(OrphanFileDeletionMetrics orphanFileDeletionMetrics) {
            this.orphanFileDeletionMetrics = orphanFileDeletionMetrics;
            return this;
        }

        public TableOptimizerRun build() {
            return new TableOptimizerRun(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TableOptimizerRun> {
        public Builder eventType(String var1);

        public Builder eventType(TableOptimizerEventType var1);

        public Builder startTimestamp(Instant var1);

        public Builder endTimestamp(Instant var1);

        @Deprecated
        public Builder metrics(RunMetrics var1);

        @Deprecated
        default public Builder metrics(Consumer<RunMetrics.Builder> metrics) {
            return this.metrics((RunMetrics)((RunMetrics.Builder)RunMetrics.builder().applyMutation(metrics)).build());
        }

        public Builder error(String var1);

        public Builder compactionMetrics(CompactionMetrics var1);

        default public Builder compactionMetrics(Consumer<CompactionMetrics.Builder> compactionMetrics) {
            return this.compactionMetrics((CompactionMetrics)((CompactionMetrics.Builder)CompactionMetrics.builder().applyMutation(compactionMetrics)).build());
        }

        public Builder retentionMetrics(RetentionMetrics var1);

        default public Builder retentionMetrics(Consumer<RetentionMetrics.Builder> retentionMetrics) {
            return this.retentionMetrics((RetentionMetrics)((RetentionMetrics.Builder)RetentionMetrics.builder().applyMutation(retentionMetrics)).build());
        }

        public Builder orphanFileDeletionMetrics(OrphanFileDeletionMetrics var1);

        default public Builder orphanFileDeletionMetrics(Consumer<OrphanFileDeletionMetrics.Builder> orphanFileDeletionMetrics) {
            return this.orphanFileDeletionMetrics((OrphanFileDeletionMetrics)((OrphanFileDeletionMetrics.Builder)OrphanFileDeletionMetrics.builder().applyMutation(orphanFileDeletionMetrics)).build());
        }
    }
}

