/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MongoDBTarget
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MongoDBTarget> {
    private static final SdkField<String> CONNECTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionName").getter(MongoDBTarget.getter(MongoDBTarget::connectionName)).setter(MongoDBTarget.setter(Builder::connectionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionName").build()}).build();
    private static final SdkField<String> PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Path").getter(MongoDBTarget.getter(MongoDBTarget::path)).setter(MongoDBTarget.setter(Builder::path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Path").build()}).build();
    private static final SdkField<Boolean> SCAN_ALL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ScanAll").getter(MongoDBTarget.getter(MongoDBTarget::scanAll)).setter(MongoDBTarget.setter(Builder::scanAll)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScanAll").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_NAME_FIELD, PATH_FIELD, SCAN_ALL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ConnectionName", CONNECTION_NAME_FIELD);
            this.put("Path", PATH_FIELD);
            this.put("ScanAll", SCAN_ALL_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String connectionName;
    private final String path;
    private final Boolean scanAll;

    private MongoDBTarget(BuilderImpl builder) {
        this.connectionName = builder.connectionName;
        this.path = builder.path;
        this.scanAll = builder.scanAll;
    }

    public final String connectionName() {
        return this.connectionName;
    }

    public final String path() {
        return this.path;
    }

    public final Boolean scanAll() {
        return this.scanAll;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanAll());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MongoDBTarget)) {
            return false;
        }
        MongoDBTarget other = (MongoDBTarget)obj;
        return Objects.equals(this.connectionName(), other.connectionName()) && Objects.equals(this.path(), other.path()) && Objects.equals(this.scanAll(), other.scanAll());
    }

    public final String toString() {
        return ToString.builder((String)"MongoDBTarget").add("ConnectionName", (Object)this.connectionName()).add("Path", (Object)this.path()).add("ScanAll", (Object)this.scanAll()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConnectionName": {
                return Optional.ofNullable(clazz.cast(this.connectionName()));
            }
            case "Path": {
                return Optional.ofNullable(clazz.cast(this.path()));
            }
            case "ScanAll": {
                return Optional.ofNullable(clazz.cast(this.scanAll()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MongoDBTarget, T> g) {
        return obj -> g.apply((MongoDBTarget)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String connectionName;
        private String path;
        private Boolean scanAll;

        private BuilderImpl() {
        }

        private BuilderImpl(MongoDBTarget model) {
            this.connectionName(model.connectionName);
            this.path(model.path);
            this.scanAll(model.scanAll);
        }

        public final String getConnectionName() {
            return this.connectionName;
        }

        public final void setConnectionName(String connectionName) {
            this.connectionName = connectionName;
        }

        @Override
        public final Builder connectionName(String connectionName) {
            this.connectionName = connectionName;
            return this;
        }

        public final String getPath() {
            return this.path;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final Boolean getScanAll() {
            return this.scanAll;
        }

        public final void setScanAll(Boolean scanAll) {
            this.scanAll = scanAll;
        }

        @Override
        public final Builder scanAll(Boolean scanAll) {
            this.scanAll = scanAll;
            return this;
        }

        public MongoDBTarget build() {
            return new MongoDBTarget(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MongoDBTarget> {
        public Builder connectionName(String var1);

        public Builder path(String var1);

        public Builder scanAll(Boolean var1);
    }
}

