/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.BatchGetTableOptimizerError;
import software.amazon.awssdk.services.glue.model.BatchGetTableOptimizerErrorsCopier;
import software.amazon.awssdk.services.glue.model.BatchTableOptimizer;
import software.amazon.awssdk.services.glue.model.BatchTableOptimizersCopier;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetTableOptimizerResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, BatchGetTableOptimizerResponse> {
    private static final SdkField<List<BatchTableOptimizer>> TABLE_OPTIMIZERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TableOptimizers").getter(BatchGetTableOptimizerResponse.getter(BatchGetTableOptimizerResponse::tableOptimizers)).setter(BatchGetTableOptimizerResponse.setter(Builder::tableOptimizers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableOptimizers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchTableOptimizer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<BatchGetTableOptimizerError>> FAILURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Failures").getter(BatchGetTableOptimizerResponse.getter(BatchGetTableOptimizerResponse::failures)).setter(BatchGetTableOptimizerResponse.setter(Builder::failures)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Failures").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchGetTableOptimizerError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_OPTIMIZERS_FIELD, FAILURES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("TableOptimizers", TABLE_OPTIMIZERS_FIELD);
            this.put("Failures", FAILURES_FIELD);
        }
    });
    private final List<BatchTableOptimizer> tableOptimizers;
    private final List<BatchGetTableOptimizerError> failures;

    private BatchGetTableOptimizerResponse(BuilderImpl builder) {
        super(builder);
        this.tableOptimizers = builder.tableOptimizers;
        this.failures = builder.failures;
    }

    public final boolean hasTableOptimizers() {
        return this.tableOptimizers != null && !(this.tableOptimizers instanceof SdkAutoConstructList);
    }

    public final List<BatchTableOptimizer> tableOptimizers() {
        return this.tableOptimizers;
    }

    public final boolean hasFailures() {
        return this.failures != null && !(this.failures instanceof SdkAutoConstructList);
    }

    public final List<BatchGetTableOptimizerError> failures() {
        return this.failures;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTableOptimizers() ? this.tableOptimizers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailures() ? this.failures() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetTableOptimizerResponse)) {
            return false;
        }
        BatchGetTableOptimizerResponse other = (BatchGetTableOptimizerResponse)((Object)obj);
        return this.hasTableOptimizers() == other.hasTableOptimizers() && Objects.equals(this.tableOptimizers(), other.tableOptimizers()) && this.hasFailures() == other.hasFailures() && Objects.equals(this.failures(), other.failures());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetTableOptimizerResponse").add("TableOptimizers", this.hasTableOptimizers() ? this.tableOptimizers() : null).add("Failures", this.hasFailures() ? this.failures() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TableOptimizers": {
                return Optional.ofNullable(clazz.cast(this.tableOptimizers()));
            }
            case "Failures": {
                return Optional.ofNullable(clazz.cast(this.failures()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetTableOptimizerResponse, T> g) {
        return obj -> g.apply((BatchGetTableOptimizerResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private List<BatchTableOptimizer> tableOptimizers = DefaultSdkAutoConstructList.getInstance();
        private List<BatchGetTableOptimizerError> failures = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetTableOptimizerResponse model) {
            super(model);
            this.tableOptimizers(model.tableOptimizers);
            this.failures(model.failures);
        }

        public final List<BatchTableOptimizer.Builder> getTableOptimizers() {
            List<BatchTableOptimizer.Builder> result = BatchTableOptimizersCopier.copyToBuilder(this.tableOptimizers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTableOptimizers(Collection<BatchTableOptimizer.BuilderImpl> tableOptimizers) {
            this.tableOptimizers = BatchTableOptimizersCopier.copyFromBuilder(tableOptimizers);
        }

        @Override
        public final Builder tableOptimizers(Collection<BatchTableOptimizer> tableOptimizers) {
            this.tableOptimizers = BatchTableOptimizersCopier.copy(tableOptimizers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tableOptimizers(BatchTableOptimizer ... tableOptimizers) {
            this.tableOptimizers(Arrays.asList(tableOptimizers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tableOptimizers(Consumer<BatchTableOptimizer.Builder> ... tableOptimizers) {
            this.tableOptimizers(Stream.of(tableOptimizers).map(c -> (BatchTableOptimizer)((BatchTableOptimizer.Builder)BatchTableOptimizer.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<BatchGetTableOptimizerError.Builder> getFailures() {
            List<BatchGetTableOptimizerError.Builder> result = BatchGetTableOptimizerErrorsCopier.copyToBuilder(this.failures);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailures(Collection<BatchGetTableOptimizerError.BuilderImpl> failures) {
            this.failures = BatchGetTableOptimizerErrorsCopier.copyFromBuilder(failures);
        }

        @Override
        public final Builder failures(Collection<BatchGetTableOptimizerError> failures) {
            this.failures = BatchGetTableOptimizerErrorsCopier.copy(failures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(BatchGetTableOptimizerError ... failures) {
            this.failures(Arrays.asList(failures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(Consumer<BatchGetTableOptimizerError.Builder> ... failures) {
            this.failures(Stream.of(failures).map(c -> (BatchGetTableOptimizerError)((BatchGetTableOptimizerError.Builder)BatchGetTableOptimizerError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetTableOptimizerResponse build() {
            return new BatchGetTableOptimizerResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetTableOptimizerResponse> {
        public Builder tableOptimizers(Collection<BatchTableOptimizer> var1);

        public Builder tableOptimizers(BatchTableOptimizer ... var1);

        public Builder tableOptimizers(Consumer<BatchTableOptimizer.Builder> ... var1);

        public Builder failures(Collection<BatchGetTableOptimizerError> var1);

        public Builder failures(BatchGetTableOptimizerError ... var1);

        public Builder failures(Consumer<BatchGetTableOptimizerError.Builder> ... var1);
    }
}

