/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IcebergCompactionMetrics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IcebergCompactionMetrics> {
    private static final SdkField<Long> NUMBER_OF_BYTES_COMPACTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("NumberOfBytesCompacted").getter(IcebergCompactionMetrics.getter(IcebergCompactionMetrics::numberOfBytesCompacted)).setter(IcebergCompactionMetrics.setter(Builder::numberOfBytesCompacted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfBytesCompacted").build()}).build();
    private static final SdkField<Long> NUMBER_OF_FILES_COMPACTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("NumberOfFilesCompacted").getter(IcebergCompactionMetrics.getter(IcebergCompactionMetrics::numberOfFilesCompacted)).setter(IcebergCompactionMetrics.setter(Builder::numberOfFilesCompacted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfFilesCompacted").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_DPUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfDpus").getter(IcebergCompactionMetrics.getter(IcebergCompactionMetrics::numberOfDpus)).setter(IcebergCompactionMetrics.setter(Builder::numberOfDpus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfDpus").build()}).build();
    private static final SdkField<Double> JOB_DURATION_IN_HOUR_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("JobDurationInHour").getter(IcebergCompactionMetrics.getter(IcebergCompactionMetrics::jobDurationInHour)).setter(IcebergCompactionMetrics.setter(Builder::jobDurationInHour)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobDurationInHour").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NUMBER_OF_BYTES_COMPACTED_FIELD, NUMBER_OF_FILES_COMPACTED_FIELD, NUMBER_OF_DPUS_FIELD, JOB_DURATION_IN_HOUR_FIELD));
    private static final long serialVersionUID = 1L;
    private final Long numberOfBytesCompacted;
    private final Long numberOfFilesCompacted;
    private final Integer numberOfDpus;
    private final Double jobDurationInHour;

    private IcebergCompactionMetrics(BuilderImpl builder) {
        this.numberOfBytesCompacted = builder.numberOfBytesCompacted;
        this.numberOfFilesCompacted = builder.numberOfFilesCompacted;
        this.numberOfDpus = builder.numberOfDpus;
        this.jobDurationInHour = builder.jobDurationInHour;
    }

    public final Long numberOfBytesCompacted() {
        return this.numberOfBytesCompacted;
    }

    public final Long numberOfFilesCompacted() {
        return this.numberOfFilesCompacted;
    }

    public final Integer numberOfDpus() {
        return this.numberOfDpus;
    }

    public final Double jobDurationInHour() {
        return this.jobDurationInHour;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfBytesCompacted());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfFilesCompacted());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfDpus());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobDurationInHour());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IcebergCompactionMetrics)) {
            return false;
        }
        IcebergCompactionMetrics other = (IcebergCompactionMetrics)obj;
        return Objects.equals(this.numberOfBytesCompacted(), other.numberOfBytesCompacted()) && Objects.equals(this.numberOfFilesCompacted(), other.numberOfFilesCompacted()) && Objects.equals(this.numberOfDpus(), other.numberOfDpus()) && Objects.equals(this.jobDurationInHour(), other.jobDurationInHour());
    }

    public final String toString() {
        return ToString.builder((String)"IcebergCompactionMetrics").add("NumberOfBytesCompacted", (Object)this.numberOfBytesCompacted()).add("NumberOfFilesCompacted", (Object)this.numberOfFilesCompacted()).add("NumberOfDpus", (Object)this.numberOfDpus()).add("JobDurationInHour", (Object)this.jobDurationInHour()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NumberOfBytesCompacted": {
                return Optional.ofNullable(clazz.cast(this.numberOfBytesCompacted()));
            }
            case "NumberOfFilesCompacted": {
                return Optional.ofNullable(clazz.cast(this.numberOfFilesCompacted()));
            }
            case "NumberOfDpus": {
                return Optional.ofNullable(clazz.cast(this.numberOfDpus()));
            }
            case "JobDurationInHour": {
                return Optional.ofNullable(clazz.cast(this.jobDurationInHour()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IcebergCompactionMetrics, T> g) {
        return obj -> g.apply((IcebergCompactionMetrics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long numberOfBytesCompacted;
        private Long numberOfFilesCompacted;
        private Integer numberOfDpus;
        private Double jobDurationInHour;

        private BuilderImpl() {
        }

        private BuilderImpl(IcebergCompactionMetrics model) {
            this.numberOfBytesCompacted(model.numberOfBytesCompacted);
            this.numberOfFilesCompacted(model.numberOfFilesCompacted);
            this.numberOfDpus(model.numberOfDpus);
            this.jobDurationInHour(model.jobDurationInHour);
        }

        public final Long getNumberOfBytesCompacted() {
            return this.numberOfBytesCompacted;
        }

        public final void setNumberOfBytesCompacted(Long numberOfBytesCompacted) {
            this.numberOfBytesCompacted = numberOfBytesCompacted;
        }

        @Override
        public final Builder numberOfBytesCompacted(Long numberOfBytesCompacted) {
            this.numberOfBytesCompacted = numberOfBytesCompacted;
            return this;
        }

        public final Long getNumberOfFilesCompacted() {
            return this.numberOfFilesCompacted;
        }

        public final void setNumberOfFilesCompacted(Long numberOfFilesCompacted) {
            this.numberOfFilesCompacted = numberOfFilesCompacted;
        }

        @Override
        public final Builder numberOfFilesCompacted(Long numberOfFilesCompacted) {
            this.numberOfFilesCompacted = numberOfFilesCompacted;
            return this;
        }

        public final Integer getNumberOfDpus() {
            return this.numberOfDpus;
        }

        public final void setNumberOfDpus(Integer numberOfDpus) {
            this.numberOfDpus = numberOfDpus;
        }

        @Override
        public final Builder numberOfDpus(Integer numberOfDpus) {
            this.numberOfDpus = numberOfDpus;
            return this;
        }

        public final Double getJobDurationInHour() {
            return this.jobDurationInHour;
        }

        public final void setJobDurationInHour(Double jobDurationInHour) {
            this.jobDurationInHour = jobDurationInHour;
        }

        @Override
        public final Builder jobDurationInHour(Double jobDurationInHour) {
            this.jobDurationInHour = jobDurationInHour;
            return this;
        }

        public IcebergCompactionMetrics build() {
            return new IcebergCompactionMetrics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IcebergCompactionMetrics> {
        public Builder numberOfBytesCompacted(Long var1);

        public Builder numberOfFilesCompacted(Long var1);

        public Builder numberOfDpus(Integer var1);

        public Builder jobDurationInHour(Double var1);
    }
}

