/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.PrincipalType;
import software.amazon.awssdk.services.glue.model.ResourceUri;
import software.amazon.awssdk.services.glue.model.ResourceUriListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UserDefinedFunction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UserDefinedFunction> {
    private static final SdkField<String> FUNCTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FunctionName").getter(UserDefinedFunction.getter(UserDefinedFunction::functionName)).setter(UserDefinedFunction.setter(Builder::functionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionName").build()}).build();
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseName").getter(UserDefinedFunction.getter(UserDefinedFunction::databaseName)).setter(UserDefinedFunction.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()}).build();
    private static final SdkField<String> CLASS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClassName").getter(UserDefinedFunction.getter(UserDefinedFunction::className)).setter(UserDefinedFunction.setter(Builder::className)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClassName").build()}).build();
    private static final SdkField<String> OWNER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerName").getter(UserDefinedFunction.getter(UserDefinedFunction::ownerName)).setter(UserDefinedFunction.setter(Builder::ownerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerName").build()}).build();
    private static final SdkField<String> OWNER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerType").getter(UserDefinedFunction.getter(UserDefinedFunction::ownerTypeAsString)).setter(UserDefinedFunction.setter(Builder::ownerType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerType").build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateTime").getter(UserDefinedFunction.getter(UserDefinedFunction::createTime)).setter(UserDefinedFunction.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build()}).build();
    private static final SdkField<List<ResourceUri>> RESOURCE_URIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceUris").getter(UserDefinedFunction.getter(UserDefinedFunction::resourceUris)).setter(UserDefinedFunction.setter(Builder::resourceUris)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceUris").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceUri::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CatalogId").getter(UserDefinedFunction.getter(UserDefinedFunction::catalogId)).setter(UserDefinedFunction.setter(Builder::catalogId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_NAME_FIELD, DATABASE_NAME_FIELD, CLASS_NAME_FIELD, OWNER_NAME_FIELD, OWNER_TYPE_FIELD, CREATE_TIME_FIELD, RESOURCE_URIS_FIELD, CATALOG_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String functionName;
    private final String databaseName;
    private final String className;
    private final String ownerName;
    private final String ownerType;
    private final Instant createTime;
    private final List<ResourceUri> resourceUris;
    private final String catalogId;

    private UserDefinedFunction(BuilderImpl builder) {
        this.functionName = builder.functionName;
        this.databaseName = builder.databaseName;
        this.className = builder.className;
        this.ownerName = builder.ownerName;
        this.ownerType = builder.ownerType;
        this.createTime = builder.createTime;
        this.resourceUris = builder.resourceUris;
        this.catalogId = builder.catalogId;
    }

    public final String functionName() {
        return this.functionName;
    }

    public final String databaseName() {
        return this.databaseName;
    }

    public final String className() {
        return this.className;
    }

    public final String ownerName() {
        return this.ownerName;
    }

    public final PrincipalType ownerType() {
        return PrincipalType.fromValue(this.ownerType);
    }

    public final String ownerTypeAsString() {
        return this.ownerType;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final boolean hasResourceUris() {
        return this.resourceUris != null && !(this.resourceUris instanceof SdkAutoConstructList);
    }

    public final List<ResourceUri> resourceUris() {
        return this.resourceUris;
    }

    public final String catalogId() {
        return this.catalogId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.functionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.className());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceUris() ? this.resourceUris() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserDefinedFunction)) {
            return false;
        }
        UserDefinedFunction other = (UserDefinedFunction)obj;
        return Objects.equals(this.functionName(), other.functionName()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.className(), other.className()) && Objects.equals(this.ownerName(), other.ownerName()) && Objects.equals(this.ownerTypeAsString(), other.ownerTypeAsString()) && Objects.equals(this.createTime(), other.createTime()) && this.hasResourceUris() == other.hasResourceUris() && Objects.equals(this.resourceUris(), other.resourceUris()) && Objects.equals(this.catalogId(), other.catalogId());
    }

    public final String toString() {
        return ToString.builder((String)"UserDefinedFunction").add("FunctionName", (Object)this.functionName()).add("DatabaseName", (Object)this.databaseName()).add("ClassName", (Object)this.className()).add("OwnerName", (Object)this.ownerName()).add("OwnerType", (Object)this.ownerTypeAsString()).add("CreateTime", (Object)this.createTime()).add("ResourceUris", this.hasResourceUris() ? this.resourceUris() : null).add("CatalogId", (Object)this.catalogId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FunctionName": {
                return Optional.ofNullable(clazz.cast(this.functionName()));
            }
            case "DatabaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "ClassName": {
                return Optional.ofNullable(clazz.cast(this.className()));
            }
            case "OwnerName": {
                return Optional.ofNullable(clazz.cast(this.ownerName()));
            }
            case "OwnerType": {
                return Optional.ofNullable(clazz.cast(this.ownerTypeAsString()));
            }
            case "CreateTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "ResourceUris": {
                return Optional.ofNullable(clazz.cast(this.resourceUris()));
            }
            case "CatalogId": {
                return Optional.ofNullable(clazz.cast(this.catalogId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UserDefinedFunction, T> g) {
        return obj -> g.apply((UserDefinedFunction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String functionName;
        private String databaseName;
        private String className;
        private String ownerName;
        private String ownerType;
        private Instant createTime;
        private List<ResourceUri> resourceUris = DefaultSdkAutoConstructList.getInstance();
        private String catalogId;

        private BuilderImpl() {
        }

        private BuilderImpl(UserDefinedFunction model) {
            this.functionName(model.functionName);
            this.databaseName(model.databaseName);
            this.className(model.className);
            this.ownerName(model.ownerName);
            this.ownerType(model.ownerType);
            this.createTime(model.createTime);
            this.resourceUris(model.resourceUris);
            this.catalogId(model.catalogId);
        }

        public final String getFunctionName() {
            return this.functionName;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        @Override
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getClassName() {
            return this.className;
        }

        public final void setClassName(String className) {
            this.className = className;
        }

        @Override
        public final Builder className(String className) {
            this.className = className;
            return this;
        }

        public final String getOwnerName() {
            return this.ownerName;
        }

        public final void setOwnerName(String ownerName) {
            this.ownerName = ownerName;
        }

        @Override
        public final Builder ownerName(String ownerName) {
            this.ownerName = ownerName;
            return this;
        }

        public final String getOwnerType() {
            return this.ownerType;
        }

        public final void setOwnerType(String ownerType) {
            this.ownerType = ownerType;
        }

        @Override
        public final Builder ownerType(String ownerType) {
            this.ownerType = ownerType;
            return this;
        }

        @Override
        public final Builder ownerType(PrincipalType ownerType) {
            this.ownerType(ownerType == null ? null : ownerType.toString());
            return this;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final List<ResourceUri.Builder> getResourceUris() {
            List<ResourceUri.Builder> result = ResourceUriListCopier.copyToBuilder(this.resourceUris);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceUris(Collection<ResourceUri.BuilderImpl> resourceUris) {
            this.resourceUris = ResourceUriListCopier.copyFromBuilder(resourceUris);
        }

        @Override
        public final Builder resourceUris(Collection<ResourceUri> resourceUris) {
            this.resourceUris = ResourceUriListCopier.copy(resourceUris);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceUris(ResourceUri ... resourceUris) {
            this.resourceUris(Arrays.asList(resourceUris));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceUris(Consumer<ResourceUri.Builder> ... resourceUris) {
            this.resourceUris(Stream.of(resourceUris).map(c -> (ResourceUri)((ResourceUri.Builder)ResourceUri.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getCatalogId() {
            return this.catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public UserDefinedFunction build() {
            return new UserDefinedFunction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UserDefinedFunction> {
        public Builder functionName(String var1);

        public Builder databaseName(String var1);

        public Builder className(String var1);

        public Builder ownerName(String var1);

        public Builder ownerType(String var1);

        public Builder ownerType(PrincipalType var1);

        public Builder createTime(Instant var1);

        public Builder resourceUris(Collection<ResourceUri> var1);

        public Builder resourceUris(ResourceUri ... var1);

        public Builder resourceUris(Consumer<ResourceUri.Builder> ... var1);

        public Builder catalogId(String var1);
    }
}

