/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.AuditColumnNamesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AuditContext
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AuditContext> {
    private static final SdkField<String> ADDITIONAL_AUDIT_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AdditionalAuditContext").getter(AuditContext.getter(AuditContext::additionalAuditContext)).setter(AuditContext.setter(Builder::additionalAuditContext)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalAuditContext").build()}).build();
    private static final SdkField<List<String>> REQUESTED_COLUMNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RequestedColumns").getter(AuditContext.getter(AuditContext::requestedColumns)).setter(AuditContext.setter(Builder::requestedColumns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestedColumns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ALL_COLUMNS_REQUESTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AllColumnsRequested").getter(AuditContext.getter(AuditContext::allColumnsRequested)).setter(AuditContext.setter(Builder::allColumnsRequested)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllColumnsRequested").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDITIONAL_AUDIT_CONTEXT_FIELD, REQUESTED_COLUMNS_FIELD, ALL_COLUMNS_REQUESTED_FIELD));
    private static final long serialVersionUID = 1L;
    private final String additionalAuditContext;
    private final List<String> requestedColumns;
    private final Boolean allColumnsRequested;

    private AuditContext(BuilderImpl builder) {
        this.additionalAuditContext = builder.additionalAuditContext;
        this.requestedColumns = builder.requestedColumns;
        this.allColumnsRequested = builder.allColumnsRequested;
    }

    public final String additionalAuditContext() {
        return this.additionalAuditContext;
    }

    public final boolean hasRequestedColumns() {
        return this.requestedColumns != null && !(this.requestedColumns instanceof SdkAutoConstructList);
    }

    public final List<String> requestedColumns() {
        return this.requestedColumns;
    }

    public final Boolean allColumnsRequested() {
        return this.allColumnsRequested;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalAuditContext());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRequestedColumns() ? this.requestedColumns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.allColumnsRequested());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuditContext)) {
            return false;
        }
        AuditContext other = (AuditContext)obj;
        return Objects.equals(this.additionalAuditContext(), other.additionalAuditContext()) && this.hasRequestedColumns() == other.hasRequestedColumns() && Objects.equals(this.requestedColumns(), other.requestedColumns()) && Objects.equals(this.allColumnsRequested(), other.allColumnsRequested());
    }

    public final String toString() {
        return ToString.builder((String)"AuditContext").add("AdditionalAuditContext", (Object)this.additionalAuditContext()).add("RequestedColumns", this.hasRequestedColumns() ? this.requestedColumns() : null).add("AllColumnsRequested", (Object)this.allColumnsRequested()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdditionalAuditContext": {
                return Optional.ofNullable(clazz.cast(this.additionalAuditContext()));
            }
            case "RequestedColumns": {
                return Optional.ofNullable(clazz.cast(this.requestedColumns()));
            }
            case "AllColumnsRequested": {
                return Optional.ofNullable(clazz.cast(this.allColumnsRequested()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AuditContext, T> g) {
        return obj -> g.apply((AuditContext)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String additionalAuditContext;
        private List<String> requestedColumns = DefaultSdkAutoConstructList.getInstance();
        private Boolean allColumnsRequested;

        private BuilderImpl() {
        }

        private BuilderImpl(AuditContext model) {
            this.additionalAuditContext(model.additionalAuditContext);
            this.requestedColumns(model.requestedColumns);
            this.allColumnsRequested(model.allColumnsRequested);
        }

        public final String getAdditionalAuditContext() {
            return this.additionalAuditContext;
        }

        public final void setAdditionalAuditContext(String additionalAuditContext) {
            this.additionalAuditContext = additionalAuditContext;
        }

        @Override
        public final Builder additionalAuditContext(String additionalAuditContext) {
            this.additionalAuditContext = additionalAuditContext;
            return this;
        }

        public final Collection<String> getRequestedColumns() {
            if (this.requestedColumns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.requestedColumns;
        }

        public final void setRequestedColumns(Collection<String> requestedColumns) {
            this.requestedColumns = AuditColumnNamesListCopier.copy(requestedColumns);
        }

        @Override
        public final Builder requestedColumns(Collection<String> requestedColumns) {
            this.requestedColumns = AuditColumnNamesListCopier.copy(requestedColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requestedColumns(String ... requestedColumns) {
            this.requestedColumns(Arrays.asList(requestedColumns));
            return this;
        }

        public final Boolean getAllColumnsRequested() {
            return this.allColumnsRequested;
        }

        public final void setAllColumnsRequested(Boolean allColumnsRequested) {
            this.allColumnsRequested = allColumnsRequested;
        }

        @Override
        public final Builder allColumnsRequested(Boolean allColumnsRequested) {
            this.allColumnsRequested = allColumnsRequested;
            return this;
        }

        public AuditContext build() {
            return new AuditContext(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AuditContext> {
        public Builder additionalAuditContext(String var1);

        public Builder requestedColumns(Collection<String> var1);

        public Builder requestedColumns(String ... var1);

        public Builder allColumnsRequested(Boolean var1);
    }
}

