/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glue.GlueAsyncClient;
import software.amazon.awssdk.services.glue.internal.UserAgentUtils;
import software.amazon.awssdk.services.glue.model.ListTriggersRequest;
import software.amazon.awssdk.services.glue.model.ListTriggersResponse;

public class ListTriggersPublisher
implements SdkPublisher<ListTriggersResponse> {
    private final GlueAsyncClient client;
    private final ListTriggersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTriggersPublisher(GlueAsyncClient client, ListTriggersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTriggersPublisher(GlueAsyncClient client, ListTriggersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTriggersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTriggersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListTriggersResponseFetcher
    implements AsyncPageFetcher<ListTriggersResponse> {
        private ListTriggersResponseFetcher() {
        }

        public boolean hasNextPage(ListTriggersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTriggersResponse> nextPage(ListTriggersResponse previousPage) {
            if (previousPage == null) {
                return ListTriggersPublisher.this.client.listTriggers(ListTriggersPublisher.this.firstRequest);
            }
            return ListTriggersPublisher.this.client.listTriggers((ListTriggersRequest)((Object)ListTriggersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

