/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.FilterOperation;
import software.amazon.awssdk.services.glue.model.FilterValue;
import software.amazon.awssdk.services.glue.model.FilterValuesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FilterExpression
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FilterExpression> {
    private static final SdkField<String> OPERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Operation").getter(FilterExpression.getter(FilterExpression::operationAsString)).setter(FilterExpression.setter(Builder::operation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operation").build()}).build();
    private static final SdkField<Boolean> NEGATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Negated").getter(FilterExpression.getter(FilterExpression::negated)).setter(FilterExpression.setter(Builder::negated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Negated").build()}).build();
    private static final SdkField<List<FilterValue>> VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Values").getter(FilterExpression.getter(FilterExpression::values)).setter(FilterExpression.setter(Builder::values)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FilterValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPERATION_FIELD, NEGATED_FIELD, VALUES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String operation;
    private final Boolean negated;
    private final List<FilterValue> values;

    private FilterExpression(BuilderImpl builder) {
        this.operation = builder.operation;
        this.negated = builder.negated;
        this.values = builder.values;
    }

    public final FilterOperation operation() {
        return FilterOperation.fromValue(this.operation);
    }

    public final String operationAsString() {
        return this.operation;
    }

    public final Boolean negated() {
        return this.negated;
    }

    public final boolean hasValues() {
        return this.values != null && !(this.values instanceof SdkAutoConstructList);
    }

    public final List<FilterValue> values() {
        return this.values;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.operationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.negated());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValues() ? this.values() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilterExpression)) {
            return false;
        }
        FilterExpression other = (FilterExpression)obj;
        return Objects.equals(this.operationAsString(), other.operationAsString()) && Objects.equals(this.negated(), other.negated()) && this.hasValues() == other.hasValues() && Objects.equals(this.values(), other.values());
    }

    public final String toString() {
        return ToString.builder((String)"FilterExpression").add("Operation", (Object)this.operationAsString()).add("Negated", (Object)this.negated()).add("Values", this.hasValues() ? this.values() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Operation": {
                return Optional.ofNullable(clazz.cast(this.operationAsString()));
            }
            case "Negated": {
                return Optional.ofNullable(clazz.cast(this.negated()));
            }
            case "Values": {
                return Optional.ofNullable(clazz.cast(this.values()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FilterExpression, T> g) {
        return obj -> g.apply((FilterExpression)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String operation;
        private Boolean negated;
        private List<FilterValue> values = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FilterExpression model) {
            this.operation(model.operation);
            this.negated(model.negated);
            this.values(model.values);
        }

        public final String getOperation() {
            return this.operation;
        }

        public final void setOperation(String operation) {
            this.operation = operation;
        }

        @Override
        public final Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        @Override
        public final Builder operation(FilterOperation operation) {
            this.operation(operation == null ? null : operation.toString());
            return this;
        }

        public final Boolean getNegated() {
            return this.negated;
        }

        public final void setNegated(Boolean negated) {
            this.negated = negated;
        }

        @Override
        public final Builder negated(Boolean negated) {
            this.negated = negated;
            return this;
        }

        public final List<FilterValue.Builder> getValues() {
            List<FilterValue.Builder> result = FilterValuesCopier.copyToBuilder(this.values);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setValues(Collection<FilterValue.BuilderImpl> values) {
            this.values = FilterValuesCopier.copyFromBuilder(values);
        }

        @Override
        public final Builder values(Collection<FilterValue> values) {
            this.values = FilterValuesCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(FilterValue ... values) {
            this.values(Arrays.asList(values));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(Consumer<FilterValue.Builder> ... values) {
            this.values(Stream.of(values).map(c -> (FilterValue)((FilterValue.Builder)FilterValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public FilterExpression build() {
            return new FilterExpression(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FilterExpression> {
        public Builder operation(String var1);

        public Builder operation(FilterOperation var1);

        public Builder negated(Boolean var1);

        public Builder values(Collection<FilterValue> var1);

        public Builder values(FilterValue ... var1);

        public Builder values(Consumer<FilterValue.Builder> ... var1);
    }
}

