/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.internal.UserAgentUtils;
import software.amazon.awssdk.services.glue.model.GetPartitionIndexesRequest;
import software.amazon.awssdk.services.glue.model.GetPartitionIndexesResponse;
import software.amazon.awssdk.services.glue.model.PartitionIndexDescriptor;

public class GetPartitionIndexesIterable
implements SdkIterable<GetPartitionIndexesResponse> {
    private final GlueClient client;
    private final GetPartitionIndexesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetPartitionIndexesIterable(GlueClient client, GetPartitionIndexesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetPartitionIndexesResponseFetcher();
    }

    public Iterator<GetPartitionIndexesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PartitionIndexDescriptor> partitionIndexDescriptorList() {
        Function<GetPartitionIndexesResponse, Iterator> getIterator = response -> {
            if (response != null && response.partitionIndexDescriptorList() != null) {
                return response.partitionIndexDescriptorList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetPartitionIndexesResponseFetcher
    implements SyncPageFetcher<GetPartitionIndexesResponse> {
        private GetPartitionIndexesResponseFetcher() {
        }

        public boolean hasNextPage(GetPartitionIndexesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetPartitionIndexesResponse nextPage(GetPartitionIndexesResponse previousPage) {
            if (previousPage == null) {
                return GetPartitionIndexesIterable.this.client.getPartitionIndexes(GetPartitionIndexesIterable.this.firstRequest);
            }
            return GetPartitionIndexesIterable.this.client.getPartitionIndexes((GetPartitionIndexesRequest)((Object)GetPartitionIndexesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

