/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.DeleteConnectionNameListCopier;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDeleteConnectionRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, BatchDeleteConnectionRequest> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CatalogId").getter(BatchDeleteConnectionRequest.getter(BatchDeleteConnectionRequest::catalogId)).setter(BatchDeleteConnectionRequest.setter(Builder::catalogId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()}).build();
    private static final SdkField<List<String>> CONNECTION_NAME_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ConnectionNameList").getter(BatchDeleteConnectionRequest.getter(BatchDeleteConnectionRequest::connectionNameList)).setter(BatchDeleteConnectionRequest.setter(Builder::connectionNameList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionNameList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD, CONNECTION_NAME_LIST_FIELD));
    private final String catalogId;
    private final List<String> connectionNameList;

    private BatchDeleteConnectionRequest(BuilderImpl builder) {
        super(builder);
        this.catalogId = builder.catalogId;
        this.connectionNameList = builder.connectionNameList;
    }

    public final String catalogId() {
        return this.catalogId;
    }

    public final boolean hasConnectionNameList() {
        return this.connectionNameList != null && !(this.connectionNameList instanceof SdkAutoConstructList);
    }

    public final List<String> connectionNameList() {
        return this.connectionNameList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConnectionNameList() ? this.connectionNameList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteConnectionRequest)) {
            return false;
        }
        BatchDeleteConnectionRequest other = (BatchDeleteConnectionRequest)((Object)obj);
        return Objects.equals(this.catalogId(), other.catalogId()) && this.hasConnectionNameList() == other.hasConnectionNameList() && Objects.equals(this.connectionNameList(), other.connectionNameList());
    }

    public final String toString() {
        return ToString.builder((String)"BatchDeleteConnectionRequest").add("CatalogId", (Object)this.catalogId()).add("ConnectionNameList", this.hasConnectionNameList() ? this.connectionNameList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CatalogId": {
                return Optional.ofNullable(clazz.cast(this.catalogId()));
            }
            case "ConnectionNameList": {
                return Optional.ofNullable(clazz.cast(this.connectionNameList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteConnectionRequest, T> g) {
        return obj -> g.apply((BatchDeleteConnectionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String catalogId;
        private List<String> connectionNameList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteConnectionRequest model) {
            super(model);
            this.catalogId(model.catalogId);
            this.connectionNameList(model.connectionNameList);
        }

        public final String getCatalogId() {
            return this.catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final Collection<String> getConnectionNameList() {
            if (this.connectionNameList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.connectionNameList;
        }

        public final void setConnectionNameList(Collection<String> connectionNameList) {
            this.connectionNameList = DeleteConnectionNameListCopier.copy(connectionNameList);
        }

        @Override
        public final Builder connectionNameList(Collection<String> connectionNameList) {
            this.connectionNameList = DeleteConnectionNameListCopier.copy(connectionNameList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectionNameList(String ... connectionNameList) {
            this.connectionNameList(Arrays.asList(connectionNameList));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchDeleteConnectionRequest build() {
            return new BatchDeleteConnectionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchDeleteConnectionRequest> {
        public Builder catalogId(String var1);

        public Builder connectionNameList(Collection<String> var1);

        public Builder connectionNameList(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

