/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.ColumnStatistics;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.services.glue.model.UpdateColumnStatisticsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateColumnStatisticsForTableRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, UpdateColumnStatisticsForTableRequest> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CatalogId").getter(UpdateColumnStatisticsForTableRequest.getter(UpdateColumnStatisticsForTableRequest::catalogId)).setter(UpdateColumnStatisticsForTableRequest.setter(Builder::catalogId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()}).build();
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseName").getter(UpdateColumnStatisticsForTableRequest.getter(UpdateColumnStatisticsForTableRequest::databaseName)).setter(UpdateColumnStatisticsForTableRequest.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()}).build();
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableName").getter(UpdateColumnStatisticsForTableRequest.getter(UpdateColumnStatisticsForTableRequest::tableName)).setter(UpdateColumnStatisticsForTableRequest.setter(Builder::tableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()}).build();
    private static final SdkField<List<ColumnStatistics>> COLUMN_STATISTICS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ColumnStatisticsList").getter(UpdateColumnStatisticsForTableRequest.getter(UpdateColumnStatisticsForTableRequest::columnStatisticsList)).setter(UpdateColumnStatisticsForTableRequest.setter(Builder::columnStatisticsList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnStatisticsList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ColumnStatistics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD, DATABASE_NAME_FIELD, TABLE_NAME_FIELD, COLUMN_STATISTICS_LIST_FIELD));
    private final String catalogId;
    private final String databaseName;
    private final String tableName;
    private final List<ColumnStatistics> columnStatisticsList;

    private UpdateColumnStatisticsForTableRequest(BuilderImpl builder) {
        super(builder);
        this.catalogId = builder.catalogId;
        this.databaseName = builder.databaseName;
        this.tableName = builder.tableName;
        this.columnStatisticsList = builder.columnStatisticsList;
    }

    public final String catalogId() {
        return this.catalogId;
    }

    public final String databaseName() {
        return this.databaseName;
    }

    public final String tableName() {
        return this.tableName;
    }

    public final boolean hasColumnStatisticsList() {
        return this.columnStatisticsList != null && !(this.columnStatisticsList instanceof SdkAutoConstructList);
    }

    public final List<ColumnStatistics> columnStatisticsList() {
        return this.columnStatisticsList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasColumnStatisticsList() ? this.columnStatisticsList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateColumnStatisticsForTableRequest)) {
            return false;
        }
        UpdateColumnStatisticsForTableRequest other = (UpdateColumnStatisticsForTableRequest)((Object)obj);
        return Objects.equals(this.catalogId(), other.catalogId()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.tableName(), other.tableName()) && this.hasColumnStatisticsList() == other.hasColumnStatisticsList() && Objects.equals(this.columnStatisticsList(), other.columnStatisticsList());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateColumnStatisticsForTableRequest").add("CatalogId", (Object)this.catalogId()).add("DatabaseName", (Object)this.databaseName()).add("TableName", (Object)this.tableName()).add("ColumnStatisticsList", this.hasColumnStatisticsList() ? this.columnStatisticsList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CatalogId": {
                return Optional.ofNullable(clazz.cast(this.catalogId()));
            }
            case "DatabaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "TableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "ColumnStatisticsList": {
                return Optional.ofNullable(clazz.cast(this.columnStatisticsList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateColumnStatisticsForTableRequest, T> g) {
        return obj -> g.apply((UpdateColumnStatisticsForTableRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String catalogId;
        private String databaseName;
        private String tableName;
        private List<ColumnStatistics> columnStatisticsList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateColumnStatisticsForTableRequest model) {
            super(model);
            this.catalogId(model.catalogId);
            this.databaseName(model.databaseName);
            this.tableName(model.tableName);
            this.columnStatisticsList(model.columnStatisticsList);
        }

        public final String getCatalogId() {
            return this.catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getTableName() {
            return this.tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final List<ColumnStatistics.Builder> getColumnStatisticsList() {
            List<ColumnStatistics.Builder> result = UpdateColumnStatisticsListCopier.copyToBuilder(this.columnStatisticsList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setColumnStatisticsList(Collection<ColumnStatistics.BuilderImpl> columnStatisticsList) {
            this.columnStatisticsList = UpdateColumnStatisticsListCopier.copyFromBuilder(columnStatisticsList);
        }

        @Override
        public final Builder columnStatisticsList(Collection<ColumnStatistics> columnStatisticsList) {
            this.columnStatisticsList = UpdateColumnStatisticsListCopier.copy(columnStatisticsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnStatisticsList(ColumnStatistics ... columnStatisticsList) {
            this.columnStatisticsList(Arrays.asList(columnStatisticsList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnStatisticsList(Consumer<ColumnStatistics.Builder> ... columnStatisticsList) {
            this.columnStatisticsList(Stream.of(columnStatisticsList).map(c -> (ColumnStatistics)((ColumnStatistics.Builder)ColumnStatistics.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateColumnStatisticsForTableRequest build() {
            return new UpdateColumnStatisticsForTableRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateColumnStatisticsForTableRequest> {
        public Builder catalogId(String var1);

        public Builder databaseName(String var1);

        public Builder tableName(String var1);

        public Builder columnStatisticsList(Collection<ColumnStatistics> var1);

        public Builder columnStatisticsList(ColumnStatistics ... var1);

        public Builder columnStatisticsList(Consumer<ColumnStatistics.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

