/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.CustomEntityType;
import software.amazon.awssdk.services.glue.model.CustomEntityTypeNamesCopier;
import software.amazon.awssdk.services.glue.model.CustomEntityTypesCopier;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetCustomEntityTypesResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, BatchGetCustomEntityTypesResponse> {
    private static final SdkField<List<CustomEntityType>> CUSTOM_ENTITY_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CustomEntityTypes").getter(BatchGetCustomEntityTypesResponse.getter(BatchGetCustomEntityTypesResponse::customEntityTypes)).setter(BatchGetCustomEntityTypesResponse.setter(Builder::customEntityTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomEntityTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CustomEntityType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> CUSTOM_ENTITY_TYPES_NOT_FOUND_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CustomEntityTypesNotFound").getter(BatchGetCustomEntityTypesResponse.getter(BatchGetCustomEntityTypesResponse::customEntityTypesNotFound)).setter(BatchGetCustomEntityTypesResponse.setter(Builder::customEntityTypesNotFound)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomEntityTypesNotFound").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_ENTITY_TYPES_FIELD, CUSTOM_ENTITY_TYPES_NOT_FOUND_FIELD));
    private final List<CustomEntityType> customEntityTypes;
    private final List<String> customEntityTypesNotFound;

    private BatchGetCustomEntityTypesResponse(BuilderImpl builder) {
        super(builder);
        this.customEntityTypes = builder.customEntityTypes;
        this.customEntityTypesNotFound = builder.customEntityTypesNotFound;
    }

    public final boolean hasCustomEntityTypes() {
        return this.customEntityTypes != null && !(this.customEntityTypes instanceof SdkAutoConstructList);
    }

    public final List<CustomEntityType> customEntityTypes() {
        return this.customEntityTypes;
    }

    public final boolean hasCustomEntityTypesNotFound() {
        return this.customEntityTypesNotFound != null && !(this.customEntityTypesNotFound instanceof SdkAutoConstructList);
    }

    public final List<String> customEntityTypesNotFound() {
        return this.customEntityTypesNotFound;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomEntityTypes() ? this.customEntityTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomEntityTypesNotFound() ? this.customEntityTypesNotFound() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetCustomEntityTypesResponse)) {
            return false;
        }
        BatchGetCustomEntityTypesResponse other = (BatchGetCustomEntityTypesResponse)((Object)obj);
        return this.hasCustomEntityTypes() == other.hasCustomEntityTypes() && Objects.equals(this.customEntityTypes(), other.customEntityTypes()) && this.hasCustomEntityTypesNotFound() == other.hasCustomEntityTypesNotFound() && Objects.equals(this.customEntityTypesNotFound(), other.customEntityTypesNotFound());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetCustomEntityTypesResponse").add("CustomEntityTypes", this.hasCustomEntityTypes() ? this.customEntityTypes() : null).add("CustomEntityTypesNotFound", this.hasCustomEntityTypesNotFound() ? this.customEntityTypesNotFound() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CustomEntityTypes": {
                return Optional.ofNullable(clazz.cast(this.customEntityTypes()));
            }
            case "CustomEntityTypesNotFound": {
                return Optional.ofNullable(clazz.cast(this.customEntityTypesNotFound()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetCustomEntityTypesResponse, T> g) {
        return obj -> g.apply((BatchGetCustomEntityTypesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private List<CustomEntityType> customEntityTypes = DefaultSdkAutoConstructList.getInstance();
        private List<String> customEntityTypesNotFound = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetCustomEntityTypesResponse model) {
            super(model);
            this.customEntityTypes(model.customEntityTypes);
            this.customEntityTypesNotFound(model.customEntityTypesNotFound);
        }

        public final List<CustomEntityType.Builder> getCustomEntityTypes() {
            List<CustomEntityType.Builder> result = CustomEntityTypesCopier.copyToBuilder(this.customEntityTypes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCustomEntityTypes(Collection<CustomEntityType.BuilderImpl> customEntityTypes) {
            this.customEntityTypes = CustomEntityTypesCopier.copyFromBuilder(customEntityTypes);
        }

        @Override
        public final Builder customEntityTypes(Collection<CustomEntityType> customEntityTypes) {
            this.customEntityTypes = CustomEntityTypesCopier.copy(customEntityTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customEntityTypes(CustomEntityType ... customEntityTypes) {
            this.customEntityTypes(Arrays.asList(customEntityTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customEntityTypes(Consumer<CustomEntityType.Builder> ... customEntityTypes) {
            this.customEntityTypes(Stream.of(customEntityTypes).map(c -> (CustomEntityType)((CustomEntityType.Builder)CustomEntityType.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getCustomEntityTypesNotFound() {
            if (this.customEntityTypesNotFound instanceof SdkAutoConstructList) {
                return null;
            }
            return this.customEntityTypesNotFound;
        }

        public final void setCustomEntityTypesNotFound(Collection<String> customEntityTypesNotFound) {
            this.customEntityTypesNotFound = CustomEntityTypeNamesCopier.copy(customEntityTypesNotFound);
        }

        @Override
        public final Builder customEntityTypesNotFound(Collection<String> customEntityTypesNotFound) {
            this.customEntityTypesNotFound = CustomEntityTypeNamesCopier.copy(customEntityTypesNotFound);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customEntityTypesNotFound(String ... customEntityTypesNotFound) {
            this.customEntityTypesNotFound(Arrays.asList(customEntityTypesNotFound));
            return this;
        }

        @Override
        public BatchGetCustomEntityTypesResponse build() {
            return new BatchGetCustomEntityTypesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetCustomEntityTypesResponse> {
        public Builder customEntityTypes(Collection<CustomEntityType> var1);

        public Builder customEntityTypes(CustomEntityType ... var1);

        public Builder customEntityTypes(Consumer<CustomEntityType.Builder> ... var1);

        public Builder customEntityTypesNotFound(Collection<String> var1);

        public Builder customEntityTypesNotFound(String ... var1);
    }
}

