/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a transform that renames a single data property key.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RenameField implements SdkPojo, Serializable, ToCopyableBuilder<RenameField.Builder, RenameField> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(RenameField::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<String>> INPUTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Inputs")
            .getter(getter(RenameField::inputs))
            .setter(setter(Builder::inputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Inputs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SOURCE_PATH_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SourcePath")
            .getter(getter(RenameField::sourcePath))
            .setter(setter(Builder::sourcePath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourcePath").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> TARGET_PATH_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TargetPath")
            .getter(getter(RenameField::targetPath))
            .setter(setter(Builder::targetPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetPath").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, INPUTS_FIELD,
            SOURCE_PATH_FIELD, TARGET_PATH_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final List<String> inputs;

    private final List<String> sourcePath;

    private final List<String> targetPath;

    private RenameField(BuilderImpl builder) {
        this.name = builder.name;
        this.inputs = builder.inputs;
        this.sourcePath = builder.sourcePath;
        this.targetPath = builder.targetPath;
    }

    /**
     * <p>
     * The name of the transform node.
     * </p>
     * 
     * @return The name of the transform node.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Inputs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasInputs() {
        return inputs != null && !(inputs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The data inputs identified by their node names.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputs} method.
     * </p>
     * 
     * @return The data inputs identified by their node names.
     */
    public final List<String> inputs() {
        return inputs;
    }

    /**
     * For responses, this returns true if the service returned a value for the SourcePath property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSourcePath() {
        return sourcePath != null && !(sourcePath instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A JSON path to a variable in the data structure for the source data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSourcePath} method.
     * </p>
     * 
     * @return A JSON path to a variable in the data structure for the source data.
     */
    public final List<String> sourcePath() {
        return sourcePath;
    }

    /**
     * For responses, this returns true if the service returned a value for the TargetPath property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTargetPath() {
        return targetPath != null && !(targetPath instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A JSON path to a variable in the data structure for the target data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetPath} method.
     * </p>
     * 
     * @return A JSON path to a variable in the data structure for the target data.
     */
    public final List<String> targetPath() {
        return targetPath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasInputs() ? inputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSourcePath() ? sourcePath() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetPath() ? targetPath() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RenameField)) {
            return false;
        }
        RenameField other = (RenameField) obj;
        return Objects.equals(name(), other.name()) && hasInputs() == other.hasInputs()
                && Objects.equals(inputs(), other.inputs()) && hasSourcePath() == other.hasSourcePath()
                && Objects.equals(sourcePath(), other.sourcePath()) && hasTargetPath() == other.hasTargetPath()
                && Objects.equals(targetPath(), other.targetPath());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RenameField").add("Name", name()).add("Inputs", hasInputs() ? inputs() : null)
                .add("SourcePath", hasSourcePath() ? sourcePath() : null)
                .add("TargetPath", hasTargetPath() ? targetPath() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Inputs":
            return Optional.ofNullable(clazz.cast(inputs()));
        case "SourcePath":
            return Optional.ofNullable(clazz.cast(sourcePath()));
        case "TargetPath":
            return Optional.ofNullable(clazz.cast(targetPath()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RenameField, T> g) {
        return obj -> g.apply((RenameField) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RenameField> {
        /**
         * <p>
         * The name of the transform node.
         * </p>
         * 
         * @param name
         *        The name of the transform node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The data inputs identified by their node names.
         * </p>
         * 
         * @param inputs
         *        The data inputs identified by their node names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputs(Collection<String> inputs);

        /**
         * <p>
         * The data inputs identified by their node names.
         * </p>
         * 
         * @param inputs
         *        The data inputs identified by their node names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputs(String... inputs);

        /**
         * <p>
         * A JSON path to a variable in the data structure for the source data.
         * </p>
         * 
         * @param sourcePath
         *        A JSON path to a variable in the data structure for the source data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourcePath(Collection<String> sourcePath);

        /**
         * <p>
         * A JSON path to a variable in the data structure for the source data.
         * </p>
         * 
         * @param sourcePath
         *        A JSON path to a variable in the data structure for the source data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourcePath(String... sourcePath);

        /**
         * <p>
         * A JSON path to a variable in the data structure for the target data.
         * </p>
         * 
         * @param targetPath
         *        A JSON path to a variable in the data structure for the target data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetPath(Collection<String> targetPath);

        /**
         * <p>
         * A JSON path to a variable in the data structure for the target data.
         * </p>
         * 
         * @param targetPath
         *        A JSON path to a variable in the data structure for the target data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetPath(String... targetPath);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private List<String> inputs = DefaultSdkAutoConstructList.getInstance();

        private List<String> sourcePath = DefaultSdkAutoConstructList.getInstance();

        private List<String> targetPath = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RenameField model) {
            name(model.name);
            inputs(model.inputs);
            sourcePath(model.sourcePath);
            targetPath(model.targetPath);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getInputs() {
            if (inputs instanceof SdkAutoConstructList) {
                return null;
            }
            return inputs;
        }

        public final void setInputs(Collection<String> inputs) {
            this.inputs = OneInputCopier.copy(inputs);
        }

        @Override
        public final Builder inputs(Collection<String> inputs) {
            this.inputs = OneInputCopier.copy(inputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(String... inputs) {
            inputs(Arrays.asList(inputs));
            return this;
        }

        public final Collection<String> getSourcePath() {
            if (sourcePath instanceof SdkAutoConstructList) {
                return null;
            }
            return sourcePath;
        }

        public final void setSourcePath(Collection<String> sourcePath) {
            this.sourcePath = EnclosedInStringPropertiesCopier.copy(sourcePath);
        }

        @Override
        public final Builder sourcePath(Collection<String> sourcePath) {
            this.sourcePath = EnclosedInStringPropertiesCopier.copy(sourcePath);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourcePath(String... sourcePath) {
            sourcePath(Arrays.asList(sourcePath));
            return this;
        }

        public final Collection<String> getTargetPath() {
            if (targetPath instanceof SdkAutoConstructList) {
                return null;
            }
            return targetPath;
        }

        public final void setTargetPath(Collection<String> targetPath) {
            this.targetPath = EnclosedInStringPropertiesCopier.copy(targetPath);
        }

        @Override
        public final Builder targetPath(Collection<String> targetPath) {
            this.targetPath = EnclosedInStringPropertiesCopier.copy(targetPath);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetPath(String... targetPath) {
            targetPath(Arrays.asList(targetPath));
            return this;
        }

        @Override
        public RenameField build() {
            return new RenameField(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
