/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glue.GlueAsyncClient;
import software.amazon.awssdk.services.glue.model.ListDataQualityResultsRequest;
import software.amazon.awssdk.services.glue.model.ListDataQualityResultsResponse;

public class ListDataQualityResultsPublisher
implements SdkPublisher<ListDataQualityResultsResponse> {
    private final GlueAsyncClient client;
    private final ListDataQualityResultsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDataQualityResultsPublisher(GlueAsyncClient client, ListDataQualityResultsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDataQualityResultsPublisher(GlueAsyncClient client, ListDataQualityResultsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDataQualityResultsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDataQualityResultsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListDataQualityResultsResponseFetcher
    implements AsyncPageFetcher<ListDataQualityResultsResponse> {
        private ListDataQualityResultsResponseFetcher() {
        }

        public boolean hasNextPage(ListDataQualityResultsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDataQualityResultsResponse> nextPage(ListDataQualityResultsResponse previousPage) {
            if (previousPage == null) {
                return ListDataQualityResultsPublisher.this.client.listDataQualityResults(ListDataQualityResultsPublisher.this.firstRequest);
            }
            return ListDataQualityResultsPublisher.this.client.listDataQualityResults((ListDataQualityResultsRequest)((Object)ListDataQualityResultsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

