/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.services.glue.model.Statement;
import software.amazon.awssdk.services.glue.model.StatementListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListStatementsResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, ListStatementsResponse> {
    private static final SdkField<List<Statement>> STATEMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Statements").getter(ListStatementsResponse.getter(ListStatementsResponse::statements)).setter(ListStatementsResponse.setter(Builder::statements)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Statements").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Statement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListStatementsResponse.getter(ListStatementsResponse::nextToken)).setter(ListStatementsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATEMENTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<Statement> statements;
    private final String nextToken;

    private ListStatementsResponse(BuilderImpl builder) {
        super(builder);
        this.statements = builder.statements;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasStatements() {
        return this.statements != null && !(this.statements instanceof SdkAutoConstructList);
    }

    public final List<Statement> statements() {
        return this.statements;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatements() ? this.statements() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStatementsResponse)) {
            return false;
        }
        ListStatementsResponse other = (ListStatementsResponse)((Object)obj);
        return this.hasStatements() == other.hasStatements() && Objects.equals(this.statements(), other.statements()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListStatementsResponse").add("Statements", this.hasStatements() ? this.statements() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Statements": {
                return Optional.ofNullable(clazz.cast(this.statements()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListStatementsResponse, T> g) {
        return obj -> g.apply((ListStatementsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private List<Statement> statements = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStatementsResponse model) {
            super(model);
            this.statements(model.statements);
            this.nextToken(model.nextToken);
        }

        public final List<Statement.Builder> getStatements() {
            List<Statement.Builder> result = StatementListCopier.copyToBuilder(this.statements);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStatements(Collection<Statement.BuilderImpl> statements) {
            this.statements = StatementListCopier.copyFromBuilder(statements);
        }

        @Override
        public final Builder statements(Collection<Statement> statements) {
            this.statements = StatementListCopier.copy(statements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statements(Statement ... statements) {
            this.statements(Arrays.asList(statements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statements(Consumer<Statement.Builder> ... statements) {
            this.statements(Stream.of(statements).map(c -> (Statement)((Statement.Builder)Statement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListStatementsResponse build() {
            return new ListStatementsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListStatementsResponse> {
        public Builder statements(Collection<Statement> var1);

        public Builder statements(Statement ... var1);

        public Builder statements(Consumer<Statement.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

