/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.services.glue.model.TaskRunFilterCriteria;
import software.amazon.awssdk.services.glue.model.TaskRunSortCriteria;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetMlTaskRunsRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, GetMlTaskRunsRequest> {
    private static final SdkField<String> TRANSFORM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransformId").getter(GetMlTaskRunsRequest.getter(GetMlTaskRunsRequest::transformId)).setter(GetMlTaskRunsRequest.setter(Builder::transformId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformId").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetMlTaskRunsRequest.getter(GetMlTaskRunsRequest::nextToken)).setter(GetMlTaskRunsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(GetMlTaskRunsRequest.getter(GetMlTaskRunsRequest::maxResults)).setter(GetMlTaskRunsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<TaskRunFilterCriteria> FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Filter").getter(GetMlTaskRunsRequest.getter(GetMlTaskRunsRequest::filter)).setter(GetMlTaskRunsRequest.setter(Builder::filter)).constructor(TaskRunFilterCriteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build()}).build();
    private static final SdkField<TaskRunSortCriteria> SORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Sort").getter(GetMlTaskRunsRequest.getter(GetMlTaskRunsRequest::sort)).setter(GetMlTaskRunsRequest.setter(Builder::sort)).constructor(TaskRunSortCriteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sort").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSFORM_ID_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, FILTER_FIELD, SORT_FIELD));
    private final String transformId;
    private final String nextToken;
    private final Integer maxResults;
    private final TaskRunFilterCriteria filter;
    private final TaskRunSortCriteria sort;

    private GetMlTaskRunsRequest(BuilderImpl builder) {
        super(builder);
        this.transformId = builder.transformId;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.filter = builder.filter;
        this.sort = builder.sort;
    }

    public final String transformId() {
        return this.transformId;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final TaskRunFilterCriteria filter() {
        return this.filter;
    }

    public final TaskRunSortCriteria sort() {
        return this.sort;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.transformId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.filter());
        hashCode = 31 * hashCode + Objects.hashCode(this.sort());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMlTaskRunsRequest)) {
            return false;
        }
        GetMlTaskRunsRequest other = (GetMlTaskRunsRequest)((Object)obj);
        return Objects.equals(this.transformId(), other.transformId()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.filter(), other.filter()) && Objects.equals(this.sort(), other.sort());
    }

    public final String toString() {
        return ToString.builder((String)"GetMlTaskRunsRequest").add("TransformId", (Object)this.transformId()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("Filter", (Object)this.filter()).add("Sort", (Object)this.sort()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TransformId": {
                return Optional.ofNullable(clazz.cast(this.transformId()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "Filter": {
                return Optional.ofNullable(clazz.cast(this.filter()));
            }
            case "Sort": {
                return Optional.ofNullable(clazz.cast(this.sort()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMlTaskRunsRequest, T> g) {
        return obj -> g.apply((GetMlTaskRunsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String transformId;
        private String nextToken;
        private Integer maxResults;
        private TaskRunFilterCriteria filter;
        private TaskRunSortCriteria sort;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMlTaskRunsRequest model) {
            super(model);
            this.transformId(model.transformId);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.filter(model.filter);
            this.sort(model.sort);
        }

        public final String getTransformId() {
            return this.transformId;
        }

        public final void setTransformId(String transformId) {
            this.transformId = transformId;
        }

        @Override
        @Transient
        public final Builder transformId(String transformId) {
            this.transformId = transformId;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final TaskRunFilterCriteria.Builder getFilter() {
            return this.filter != null ? this.filter.toBuilder() : null;
        }

        public final void setFilter(TaskRunFilterCriteria.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        @Transient
        public final Builder filter(TaskRunFilterCriteria filter) {
            this.filter = filter;
            return this;
        }

        public final TaskRunSortCriteria.Builder getSort() {
            return this.sort != null ? this.sort.toBuilder() : null;
        }

        public final void setSort(TaskRunSortCriteria.BuilderImpl sort) {
            this.sort = sort != null ? sort.build() : null;
        }

        @Override
        @Transient
        public final Builder sort(TaskRunSortCriteria sort) {
            this.sort = sort;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetMlTaskRunsRequest build() {
            return new GetMlTaskRunsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetMlTaskRunsRequest> {
        public Builder transformId(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder filter(TaskRunFilterCriteria var1);

        default public Builder filter(Consumer<TaskRunFilterCriteria.Builder> filter) {
            return this.filter((TaskRunFilterCriteria)((TaskRunFilterCriteria.Builder)TaskRunFilterCriteria.builder().applyMutation(filter)).build());
        }

        public Builder sort(TaskRunSortCriteria var1);

        default public Builder sort(Consumer<TaskRunSortCriteria.Builder> sort) {
            return this.sort((TaskRunSortCriteria)((TaskRunSortCriteria.Builder)TaskRunSortCriteria.builder().applyMutation(sort)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

