/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.services.glue.model.SchemaId;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegisterSchemaVersionRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, RegisterSchemaVersionRequest> {
    private static final SdkField<SchemaId> SCHEMA_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SchemaId").getter(RegisterSchemaVersionRequest.getter(RegisterSchemaVersionRequest::schemaId)).setter(RegisterSchemaVersionRequest.setter(Builder::schemaId)).constructor(SchemaId::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaId").build()}).build();
    private static final SdkField<String> SCHEMA_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SchemaDefinition").getter(RegisterSchemaVersionRequest.getter(RegisterSchemaVersionRequest::schemaDefinition)).setter(RegisterSchemaVersionRequest.setter(Builder::schemaDefinition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaDefinition").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_ID_FIELD, SCHEMA_DEFINITION_FIELD));
    private final SchemaId schemaId;
    private final String schemaDefinition;

    private RegisterSchemaVersionRequest(BuilderImpl builder) {
        super(builder);
        this.schemaId = builder.schemaId;
        this.schemaDefinition = builder.schemaDefinition;
    }

    public final SchemaId schemaId() {
        return this.schemaId;
    }

    public final String schemaDefinition() {
        return this.schemaDefinition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaId());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaDefinition());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterSchemaVersionRequest)) {
            return false;
        }
        RegisterSchemaVersionRequest other = (RegisterSchemaVersionRequest)((Object)obj);
        return Objects.equals(this.schemaId(), other.schemaId()) && Objects.equals(this.schemaDefinition(), other.schemaDefinition());
    }

    public final String toString() {
        return ToString.builder((String)"RegisterSchemaVersionRequest").add("SchemaId", (Object)this.schemaId()).add("SchemaDefinition", (Object)this.schemaDefinition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SchemaId": {
                return Optional.ofNullable(clazz.cast(this.schemaId()));
            }
            case "SchemaDefinition": {
                return Optional.ofNullable(clazz.cast(this.schemaDefinition()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterSchemaVersionRequest, T> g) {
        return obj -> g.apply((RegisterSchemaVersionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private SchemaId schemaId;
        private String schemaDefinition;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterSchemaVersionRequest model) {
            super(model);
            this.schemaId(model.schemaId);
            this.schemaDefinition(model.schemaDefinition);
        }

        public final SchemaId.Builder getSchemaId() {
            return this.schemaId != null ? this.schemaId.toBuilder() : null;
        }

        @Override
        public final Builder schemaId(SchemaId schemaId) {
            this.schemaId = schemaId;
            return this;
        }

        public final void setSchemaId(SchemaId.BuilderImpl schemaId) {
            this.schemaId = schemaId != null ? schemaId.build() : null;
        }

        public final String getSchemaDefinition() {
            return this.schemaDefinition;
        }

        @Override
        public final Builder schemaDefinition(String schemaDefinition) {
            this.schemaDefinition = schemaDefinition;
            return this;
        }

        public final void setSchemaDefinition(String schemaDefinition) {
            this.schemaDefinition = schemaDefinition;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterSchemaVersionRequest build() {
            return new RegisterSchemaVersionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RegisterSchemaVersionRequest> {
        public Builder schemaId(SchemaId var1);

        default public Builder schemaId(Consumer<SchemaId.Builder> schemaId) {
            return this.schemaId((SchemaId)((SchemaId.Builder)SchemaId.builder().applyMutation(schemaId)).build());
        }

        public Builder schemaDefinition(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

