/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConfusionMatrix
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConfusionMatrix> {
    private static final SdkField<Long> NUM_TRUE_POSITIVES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("NumTruePositives").getter(ConfusionMatrix.getter(ConfusionMatrix::numTruePositives)).setter(ConfusionMatrix.setter(Builder::numTruePositives)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumTruePositives").build()}).build();
    private static final SdkField<Long> NUM_FALSE_POSITIVES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("NumFalsePositives").getter(ConfusionMatrix.getter(ConfusionMatrix::numFalsePositives)).setter(ConfusionMatrix.setter(Builder::numFalsePositives)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumFalsePositives").build()}).build();
    private static final SdkField<Long> NUM_TRUE_NEGATIVES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("NumTrueNegatives").getter(ConfusionMatrix.getter(ConfusionMatrix::numTrueNegatives)).setter(ConfusionMatrix.setter(Builder::numTrueNegatives)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumTrueNegatives").build()}).build();
    private static final SdkField<Long> NUM_FALSE_NEGATIVES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("NumFalseNegatives").getter(ConfusionMatrix.getter(ConfusionMatrix::numFalseNegatives)).setter(ConfusionMatrix.setter(Builder::numFalseNegatives)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumFalseNegatives").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NUM_TRUE_POSITIVES_FIELD, NUM_FALSE_POSITIVES_FIELD, NUM_TRUE_NEGATIVES_FIELD, NUM_FALSE_NEGATIVES_FIELD));
    private static final long serialVersionUID = 1L;
    private final Long numTruePositives;
    private final Long numFalsePositives;
    private final Long numTrueNegatives;
    private final Long numFalseNegatives;

    private ConfusionMatrix(BuilderImpl builder) {
        this.numTruePositives = builder.numTruePositives;
        this.numFalsePositives = builder.numFalsePositives;
        this.numTrueNegatives = builder.numTrueNegatives;
        this.numFalseNegatives = builder.numFalseNegatives;
    }

    public final Long numTruePositives() {
        return this.numTruePositives;
    }

    public final Long numFalsePositives() {
        return this.numFalsePositives;
    }

    public final Long numTrueNegatives() {
        return this.numTrueNegatives;
    }

    public final Long numFalseNegatives() {
        return this.numFalseNegatives;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.numTruePositives());
        hashCode = 31 * hashCode + Objects.hashCode(this.numFalsePositives());
        hashCode = 31 * hashCode + Objects.hashCode(this.numTrueNegatives());
        hashCode = 31 * hashCode + Objects.hashCode(this.numFalseNegatives());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfusionMatrix)) {
            return false;
        }
        ConfusionMatrix other = (ConfusionMatrix)obj;
        return Objects.equals(this.numTruePositives(), other.numTruePositives()) && Objects.equals(this.numFalsePositives(), other.numFalsePositives()) && Objects.equals(this.numTrueNegatives(), other.numTrueNegatives()) && Objects.equals(this.numFalseNegatives(), other.numFalseNegatives());
    }

    public final String toString() {
        return ToString.builder((String)"ConfusionMatrix").add("NumTruePositives", (Object)this.numTruePositives()).add("NumFalsePositives", (Object)this.numFalsePositives()).add("NumTrueNegatives", (Object)this.numTrueNegatives()).add("NumFalseNegatives", (Object)this.numFalseNegatives()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NumTruePositives": {
                return Optional.ofNullable(clazz.cast(this.numTruePositives()));
            }
            case "NumFalsePositives": {
                return Optional.ofNullable(clazz.cast(this.numFalsePositives()));
            }
            case "NumTrueNegatives": {
                return Optional.ofNullable(clazz.cast(this.numTrueNegatives()));
            }
            case "NumFalseNegatives": {
                return Optional.ofNullable(clazz.cast(this.numFalseNegatives()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConfusionMatrix, T> g) {
        return obj -> g.apply((ConfusionMatrix)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long numTruePositives;
        private Long numFalsePositives;
        private Long numTrueNegatives;
        private Long numFalseNegatives;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfusionMatrix model) {
            this.numTruePositives(model.numTruePositives);
            this.numFalsePositives(model.numFalsePositives);
            this.numTrueNegatives(model.numTrueNegatives);
            this.numFalseNegatives(model.numFalseNegatives);
        }

        public final Long getNumTruePositives() {
            return this.numTruePositives;
        }

        public final void setNumTruePositives(Long numTruePositives) {
            this.numTruePositives = numTruePositives;
        }

        @Override
        public final Builder numTruePositives(Long numTruePositives) {
            this.numTruePositives = numTruePositives;
            return this;
        }

        public final Long getNumFalsePositives() {
            return this.numFalsePositives;
        }

        public final void setNumFalsePositives(Long numFalsePositives) {
            this.numFalsePositives = numFalsePositives;
        }

        @Override
        public final Builder numFalsePositives(Long numFalsePositives) {
            this.numFalsePositives = numFalsePositives;
            return this;
        }

        public final Long getNumTrueNegatives() {
            return this.numTrueNegatives;
        }

        public final void setNumTrueNegatives(Long numTrueNegatives) {
            this.numTrueNegatives = numTrueNegatives;
        }

        @Override
        public final Builder numTrueNegatives(Long numTrueNegatives) {
            this.numTrueNegatives = numTrueNegatives;
            return this;
        }

        public final Long getNumFalseNegatives() {
            return this.numFalseNegatives;
        }

        public final void setNumFalseNegatives(Long numFalseNegatives) {
            this.numFalseNegatives = numFalseNegatives;
        }

        @Override
        public final Builder numFalseNegatives(Long numFalseNegatives) {
            this.numFalseNegatives = numFalseNegatives;
            return this;
        }

        public ConfusionMatrix build() {
            return new ConfusionMatrix(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConfusionMatrix> {
        public Builder numTruePositives(Long var1);

        public Builder numFalsePositives(Long var1);

        public Builder numTrueNegatives(Long var1);

        public Builder numFalseNegatives(Long var1);
    }
}

