/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.model.GetSecurityConfigurationsRequest;
import software.amazon.awssdk.services.glue.model.GetSecurityConfigurationsResponse;
import software.amazon.awssdk.services.glue.model.SecurityConfiguration;

public class GetSecurityConfigurationsIterable
implements SdkIterable<GetSecurityConfigurationsResponse> {
    private final GlueClient client;
    private final GetSecurityConfigurationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetSecurityConfigurationsIterable(GlueClient client, GetSecurityConfigurationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetSecurityConfigurationsResponseFetcher();
    }

    public Iterator<GetSecurityConfigurationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SecurityConfiguration> securityConfigurations() {
        Function<GetSecurityConfigurationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.securityConfigurations() != null) {
                return response.securityConfigurations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetSecurityConfigurationsResponseFetcher
    implements SyncPageFetcher<GetSecurityConfigurationsResponse> {
        private GetSecurityConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(GetSecurityConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetSecurityConfigurationsResponse nextPage(GetSecurityConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return GetSecurityConfigurationsIterable.this.client.getSecurityConfigurations(GetSecurityConfigurationsIterable.this.firstRequest);
            }
            return GetSecurityConfigurationsIterable.this.client.getSecurityConfigurations((GetSecurityConfigurationsRequest)((Object)GetSecurityConfigurationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

