/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.S3Target;

final class S3TargetListCopier {
    S3TargetListCopier() {
    }

    static List<S3Target> copy(Collection<? extends S3Target> s3TargetListParam) {
        Object list;
        if (s3TargetListParam == null || s3TargetListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList();
            s3TargetListParam.forEach(entry -> modifiableList.add(entry));
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<S3Target> copyFromBuilder(Collection<? extends S3Target.Builder> s3TargetListParam) {
        Object list;
        if (s3TargetListParam == null || s3TargetListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList();
            s3TargetListParam.forEach(entry -> {
                S3Target member = entry == null ? null : (S3Target)entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<S3Target.Builder> copyToBuilder(Collection<? extends S3Target> s3TargetListParam) {
        Object list;
        if (s3TargetListParam == null || s3TargetListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList();
            s3TargetListParam.forEach(entry -> {
                S3Target.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}

