/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glue.GlueAsyncClient;
import software.amazon.awssdk.services.glue.model.GetUnfilteredPartitionsMetadataRequest;
import software.amazon.awssdk.services.glue.model.GetUnfilteredPartitionsMetadataResponse;

public class GetUnfilteredPartitionsMetadataPublisher
implements SdkPublisher<GetUnfilteredPartitionsMetadataResponse> {
    private final GlueAsyncClient client;
    private final GetUnfilteredPartitionsMetadataRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetUnfilteredPartitionsMetadataPublisher(GlueAsyncClient client, GetUnfilteredPartitionsMetadataRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetUnfilteredPartitionsMetadataPublisher(GlueAsyncClient client, GetUnfilteredPartitionsMetadataRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetUnfilteredPartitionsMetadataResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetUnfilteredPartitionsMetadataResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetUnfilteredPartitionsMetadataResponseFetcher
    implements AsyncPageFetcher<GetUnfilteredPartitionsMetadataResponse> {
        private GetUnfilteredPartitionsMetadataResponseFetcher() {
        }

        public boolean hasNextPage(GetUnfilteredPartitionsMetadataResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetUnfilteredPartitionsMetadataResponse> nextPage(GetUnfilteredPartitionsMetadataResponse previousPage) {
            if (previousPage == null) {
                return GetUnfilteredPartitionsMetadataPublisher.this.client.getUnfilteredPartitionsMetadata(GetUnfilteredPartitionsMetadataPublisher.this.firstRequest);
            }
            return GetUnfilteredPartitionsMetadataPublisher.this.client.getUnfilteredPartitionsMetadata((GetUnfilteredPartitionsMetadataRequest)((Object)GetUnfilteredPartitionsMetadataPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

