/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Compatibility {
    NONE("NONE"),
    DISABLED("DISABLED"),
    BACKWARD("BACKWARD"),
    BACKWARD_ALL("BACKWARD_ALL"),
    FORWARD("FORWARD"),
    FORWARD_ALL("FORWARD_ALL"),
    FULL("FULL"),
    FULL_ALL("FULL_ALL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Compatibility> VALUE_MAP;
    private final String value;

    private Compatibility(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Compatibility fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Compatibility> knownValues() {
        EnumSet<Compatibility> knownValues = EnumSet.allOf(Compatibility.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Compatibility.class, Compatibility::toString);
    }
}

