/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.UpdateCatalogBehavior;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CatalogSchemaChangePolicy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CatalogSchemaChangePolicy> {
    private static final SdkField<Boolean> ENABLE_UPDATE_CATALOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableUpdateCatalog").getter(CatalogSchemaChangePolicy.getter(CatalogSchemaChangePolicy::enableUpdateCatalog)).setter(CatalogSchemaChangePolicy.setter(Builder::enableUpdateCatalog)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableUpdateCatalog").build()}).build();
    private static final SdkField<String> UPDATE_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UpdateBehavior").getter(CatalogSchemaChangePolicy.getter(CatalogSchemaChangePolicy::updateBehaviorAsString)).setter(CatalogSchemaChangePolicy.setter(Builder::updateBehavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateBehavior").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLE_UPDATE_CATALOG_FIELD, UPDATE_BEHAVIOR_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean enableUpdateCatalog;
    private final String updateBehavior;

    private CatalogSchemaChangePolicy(BuilderImpl builder) {
        this.enableUpdateCatalog = builder.enableUpdateCatalog;
        this.updateBehavior = builder.updateBehavior;
    }

    public final Boolean enableUpdateCatalog() {
        return this.enableUpdateCatalog;
    }

    public final UpdateCatalogBehavior updateBehavior() {
        return UpdateCatalogBehavior.fromValue(this.updateBehavior);
    }

    public final String updateBehaviorAsString() {
        return this.updateBehavior;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enableUpdateCatalog());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateBehaviorAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CatalogSchemaChangePolicy)) {
            return false;
        }
        CatalogSchemaChangePolicy other = (CatalogSchemaChangePolicy)obj;
        return Objects.equals(this.enableUpdateCatalog(), other.enableUpdateCatalog()) && Objects.equals(this.updateBehaviorAsString(), other.updateBehaviorAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CatalogSchemaChangePolicy").add("EnableUpdateCatalog", (Object)this.enableUpdateCatalog()).add("UpdateBehavior", (Object)this.updateBehaviorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EnableUpdateCatalog": {
                return Optional.ofNullable(clazz.cast(this.enableUpdateCatalog()));
            }
            case "UpdateBehavior": {
                return Optional.ofNullable(clazz.cast(this.updateBehaviorAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CatalogSchemaChangePolicy, T> g) {
        return obj -> g.apply((CatalogSchemaChangePolicy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enableUpdateCatalog;
        private String updateBehavior;

        private BuilderImpl() {
        }

        private BuilderImpl(CatalogSchemaChangePolicy model) {
            this.enableUpdateCatalog(model.enableUpdateCatalog);
            this.updateBehavior(model.updateBehavior);
        }

        public final Boolean getEnableUpdateCatalog() {
            return this.enableUpdateCatalog;
        }

        public final void setEnableUpdateCatalog(Boolean enableUpdateCatalog) {
            this.enableUpdateCatalog = enableUpdateCatalog;
        }

        @Override
        public final Builder enableUpdateCatalog(Boolean enableUpdateCatalog) {
            this.enableUpdateCatalog = enableUpdateCatalog;
            return this;
        }

        public final String getUpdateBehavior() {
            return this.updateBehavior;
        }

        public final void setUpdateBehavior(String updateBehavior) {
            this.updateBehavior = updateBehavior;
        }

        @Override
        public final Builder updateBehavior(String updateBehavior) {
            this.updateBehavior = updateBehavior;
            return this;
        }

        @Override
        public final Builder updateBehavior(UpdateCatalogBehavior updateBehavior) {
            this.updateBehavior(updateBehavior == null ? null : updateBehavior.toString());
            return this;
        }

        public CatalogSchemaChangePolicy build() {
            return new CatalogSchemaChangePolicy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CatalogSchemaChangePolicy> {
        public Builder enableUpdateCatalog(Boolean var1);

        public Builder updateBehavior(String var1);

        public Builder updateBehavior(UpdateCatalogBehavior var1);
    }
}

