/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KafkaStreamingSourceOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KafkaStreamingSourceOptions> {
    private static final SdkField<String> BOOTSTRAP_SERVERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BootstrapServers").getter(KafkaStreamingSourceOptions.getter(KafkaStreamingSourceOptions::bootstrapServers)).setter(KafkaStreamingSourceOptions.setter(Builder::bootstrapServers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BootstrapServers").build()}).build();
    private static final SdkField<String> SECURITY_PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecurityProtocol").getter(KafkaStreamingSourceOptions.getter(KafkaStreamingSourceOptions::securityProtocol)).setter(KafkaStreamingSourceOptions.setter(Builder::securityProtocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityProtocol").build()}).build();
    private static final SdkField<String> CONNECTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionName").getter(KafkaStreamingSourceOptions.getter(KafkaStreamingSourceOptions::connectionName)).setter(KafkaStreamingSourceOptions.setter(Builder::connectionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionName").build()}).build();
    private static final SdkField<String> TOPIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TopicName").getter(KafkaStreamingSourceOptions.getter(KafkaStreamingSourceOptions::topicName)).setter(KafkaStreamingSourceOptions.setter(Builder::topicName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicName").build()}).build();
    private static final SdkField<String> ASSIGN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Assign").getter(KafkaStreamingSourceOptions.getter(KafkaStreamingSourceOptions::assign)).setter(KafkaStreamingSourceOptions.setter(Builder::assign)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Assign").build()}).build();
    private static final SdkField<String> SUBSCRIBE_PATTERN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubscribePattern").getter(KafkaStreamingSourceOptions.getter(KafkaStreamingSourceOptions::subscribePattern)).setter(KafkaStreamingSourceOptions.setter(Builder::subscribePattern)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscribePattern").build()}).build();
    private static final SdkField<String> CLASSIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Classification").getter(KafkaStreamingSourceOptions.getter(KafkaStreamingSourceOptions::classification)).setter(KafkaStreamingSourceOptions.setter(Builder::classification)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Classification").build()}).build();
    private static final SdkField<String> DELIMITER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Delimiter").getter(KafkaStreamingSourceOptions.getter(KafkaStreamingSourceOptions::delimiter)).setter(KafkaStreamingSourceOptions.setter(Builder::delimiter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Delimiter").build()}).build();
    private static final SdkField<String> STARTING_OFFSETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StartingOffsets").getter(KafkaStreamingSourceOptions.getter(KafkaStreamingSourceOptions::startingOffsets)).setter(KafkaStreamingSourceOptions.setter(Builder::startingOffsets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartingOffsets").build()}).build();
    private static final SdkField<String> ENDING_OFFSETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndingOffsets").getter(KafkaStreamingSourceOptions.getter(KafkaStreamingSourceOptions::endingOffsets)).setter(KafkaStreamingSourceOptions.setter(Builder::endingOffsets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndingOffsets").build()}).build();
    private static final SdkField<Long> POLL_TIMEOUT_MS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("PollTimeoutMs").getter(KafkaStreamingSourceOptions.getter(KafkaStreamingSourceOptions::pollTimeoutMs)).setter(KafkaStreamingSourceOptions.setter(Builder::pollTimeoutMs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PollTimeoutMs").build()}).build();
    private static final SdkField<Integer> NUM_RETRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumRetries").getter(KafkaStreamingSourceOptions.getter(KafkaStreamingSourceOptions::numRetries)).setter(KafkaStreamingSourceOptions.setter(Builder::numRetries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumRetries").build()}).build();
    private static final SdkField<Long> RETRY_INTERVAL_MS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("RetryIntervalMs").getter(KafkaStreamingSourceOptions.getter(KafkaStreamingSourceOptions::retryIntervalMs)).setter(KafkaStreamingSourceOptions.setter(Builder::retryIntervalMs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetryIntervalMs").build()}).build();
    private static final SdkField<Long> MAX_OFFSETS_PER_TRIGGER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("MaxOffsetsPerTrigger").getter(KafkaStreamingSourceOptions.getter(KafkaStreamingSourceOptions::maxOffsetsPerTrigger)).setter(KafkaStreamingSourceOptions.setter(Builder::maxOffsetsPerTrigger)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxOffsetsPerTrigger").build()}).build();
    private static final SdkField<Integer> MIN_PARTITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinPartitions").getter(KafkaStreamingSourceOptions.getter(KafkaStreamingSourceOptions::minPartitions)).setter(KafkaStreamingSourceOptions.setter(Builder::minPartitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinPartitions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOOTSTRAP_SERVERS_FIELD, SECURITY_PROTOCOL_FIELD, CONNECTION_NAME_FIELD, TOPIC_NAME_FIELD, ASSIGN_FIELD, SUBSCRIBE_PATTERN_FIELD, CLASSIFICATION_FIELD, DELIMITER_FIELD, STARTING_OFFSETS_FIELD, ENDING_OFFSETS_FIELD, POLL_TIMEOUT_MS_FIELD, NUM_RETRIES_FIELD, RETRY_INTERVAL_MS_FIELD, MAX_OFFSETS_PER_TRIGGER_FIELD, MIN_PARTITIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String bootstrapServers;
    private final String securityProtocol;
    private final String connectionName;
    private final String topicName;
    private final String assign;
    private final String subscribePattern;
    private final String classification;
    private final String delimiter;
    private final String startingOffsets;
    private final String endingOffsets;
    private final Long pollTimeoutMs;
    private final Integer numRetries;
    private final Long retryIntervalMs;
    private final Long maxOffsetsPerTrigger;
    private final Integer minPartitions;

    private KafkaStreamingSourceOptions(BuilderImpl builder) {
        this.bootstrapServers = builder.bootstrapServers;
        this.securityProtocol = builder.securityProtocol;
        this.connectionName = builder.connectionName;
        this.topicName = builder.topicName;
        this.assign = builder.assign;
        this.subscribePattern = builder.subscribePattern;
        this.classification = builder.classification;
        this.delimiter = builder.delimiter;
        this.startingOffsets = builder.startingOffsets;
        this.endingOffsets = builder.endingOffsets;
        this.pollTimeoutMs = builder.pollTimeoutMs;
        this.numRetries = builder.numRetries;
        this.retryIntervalMs = builder.retryIntervalMs;
        this.maxOffsetsPerTrigger = builder.maxOffsetsPerTrigger;
        this.minPartitions = builder.minPartitions;
    }

    public final String bootstrapServers() {
        return this.bootstrapServers;
    }

    public final String securityProtocol() {
        return this.securityProtocol;
    }

    public final String connectionName() {
        return this.connectionName;
    }

    public final String topicName() {
        return this.topicName;
    }

    public final String assign() {
        return this.assign;
    }

    public final String subscribePattern() {
        return this.subscribePattern;
    }

    public final String classification() {
        return this.classification;
    }

    public final String delimiter() {
        return this.delimiter;
    }

    public final String startingOffsets() {
        return this.startingOffsets;
    }

    public final String endingOffsets() {
        return this.endingOffsets;
    }

    public final Long pollTimeoutMs() {
        return this.pollTimeoutMs;
    }

    public final Integer numRetries() {
        return this.numRetries;
    }

    public final Long retryIntervalMs() {
        return this.retryIntervalMs;
    }

    public final Long maxOffsetsPerTrigger() {
        return this.maxOffsetsPerTrigger;
    }

    public final Integer minPartitions() {
        return this.minPartitions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bootstrapServers());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityProtocol());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.topicName());
        hashCode = 31 * hashCode + Objects.hashCode(this.assign());
        hashCode = 31 * hashCode + Objects.hashCode(this.subscribePattern());
        hashCode = 31 * hashCode + Objects.hashCode(this.classification());
        hashCode = 31 * hashCode + Objects.hashCode(this.delimiter());
        hashCode = 31 * hashCode + Objects.hashCode(this.startingOffsets());
        hashCode = 31 * hashCode + Objects.hashCode(this.endingOffsets());
        hashCode = 31 * hashCode + Objects.hashCode(this.pollTimeoutMs());
        hashCode = 31 * hashCode + Objects.hashCode(this.numRetries());
        hashCode = 31 * hashCode + Objects.hashCode(this.retryIntervalMs());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxOffsetsPerTrigger());
        hashCode = 31 * hashCode + Objects.hashCode(this.minPartitions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KafkaStreamingSourceOptions)) {
            return false;
        }
        KafkaStreamingSourceOptions other = (KafkaStreamingSourceOptions)obj;
        return Objects.equals(this.bootstrapServers(), other.bootstrapServers()) && Objects.equals(this.securityProtocol(), other.securityProtocol()) && Objects.equals(this.connectionName(), other.connectionName()) && Objects.equals(this.topicName(), other.topicName()) && Objects.equals(this.assign(), other.assign()) && Objects.equals(this.subscribePattern(), other.subscribePattern()) && Objects.equals(this.classification(), other.classification()) && Objects.equals(this.delimiter(), other.delimiter()) && Objects.equals(this.startingOffsets(), other.startingOffsets()) && Objects.equals(this.endingOffsets(), other.endingOffsets()) && Objects.equals(this.pollTimeoutMs(), other.pollTimeoutMs()) && Objects.equals(this.numRetries(), other.numRetries()) && Objects.equals(this.retryIntervalMs(), other.retryIntervalMs()) && Objects.equals(this.maxOffsetsPerTrigger(), other.maxOffsetsPerTrigger()) && Objects.equals(this.minPartitions(), other.minPartitions());
    }

    public final String toString() {
        return ToString.builder((String)"KafkaStreamingSourceOptions").add("BootstrapServers", (Object)this.bootstrapServers()).add("SecurityProtocol", (Object)this.securityProtocol()).add("ConnectionName", (Object)this.connectionName()).add("TopicName", (Object)this.topicName()).add("Assign", (Object)this.assign()).add("SubscribePattern", (Object)this.subscribePattern()).add("Classification", (Object)this.classification()).add("Delimiter", (Object)this.delimiter()).add("StartingOffsets", (Object)this.startingOffsets()).add("EndingOffsets", (Object)this.endingOffsets()).add("PollTimeoutMs", (Object)this.pollTimeoutMs()).add("NumRetries", (Object)this.numRetries()).add("RetryIntervalMs", (Object)this.retryIntervalMs()).add("MaxOffsetsPerTrigger", (Object)this.maxOffsetsPerTrigger()).add("MinPartitions", (Object)this.minPartitions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BootstrapServers": {
                return Optional.ofNullable(clazz.cast(this.bootstrapServers()));
            }
            case "SecurityProtocol": {
                return Optional.ofNullable(clazz.cast(this.securityProtocol()));
            }
            case "ConnectionName": {
                return Optional.ofNullable(clazz.cast(this.connectionName()));
            }
            case "TopicName": {
                return Optional.ofNullable(clazz.cast(this.topicName()));
            }
            case "Assign": {
                return Optional.ofNullable(clazz.cast(this.assign()));
            }
            case "SubscribePattern": {
                return Optional.ofNullable(clazz.cast(this.subscribePattern()));
            }
            case "Classification": {
                return Optional.ofNullable(clazz.cast(this.classification()));
            }
            case "Delimiter": {
                return Optional.ofNullable(clazz.cast(this.delimiter()));
            }
            case "StartingOffsets": {
                return Optional.ofNullable(clazz.cast(this.startingOffsets()));
            }
            case "EndingOffsets": {
                return Optional.ofNullable(clazz.cast(this.endingOffsets()));
            }
            case "PollTimeoutMs": {
                return Optional.ofNullable(clazz.cast(this.pollTimeoutMs()));
            }
            case "NumRetries": {
                return Optional.ofNullable(clazz.cast(this.numRetries()));
            }
            case "RetryIntervalMs": {
                return Optional.ofNullable(clazz.cast(this.retryIntervalMs()));
            }
            case "MaxOffsetsPerTrigger": {
                return Optional.ofNullable(clazz.cast(this.maxOffsetsPerTrigger()));
            }
            case "MinPartitions": {
                return Optional.ofNullable(clazz.cast(this.minPartitions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KafkaStreamingSourceOptions, T> g) {
        return obj -> g.apply((KafkaStreamingSourceOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String bootstrapServers;
        private String securityProtocol;
        private String connectionName;
        private String topicName;
        private String assign;
        private String subscribePattern;
        private String classification;
        private String delimiter;
        private String startingOffsets;
        private String endingOffsets;
        private Long pollTimeoutMs;
        private Integer numRetries;
        private Long retryIntervalMs;
        private Long maxOffsetsPerTrigger;
        private Integer minPartitions;

        private BuilderImpl() {
        }

        private BuilderImpl(KafkaStreamingSourceOptions model) {
            this.bootstrapServers(model.bootstrapServers);
            this.securityProtocol(model.securityProtocol);
            this.connectionName(model.connectionName);
            this.topicName(model.topicName);
            this.assign(model.assign);
            this.subscribePattern(model.subscribePattern);
            this.classification(model.classification);
            this.delimiter(model.delimiter);
            this.startingOffsets(model.startingOffsets);
            this.endingOffsets(model.endingOffsets);
            this.pollTimeoutMs(model.pollTimeoutMs);
            this.numRetries(model.numRetries);
            this.retryIntervalMs(model.retryIntervalMs);
            this.maxOffsetsPerTrigger(model.maxOffsetsPerTrigger);
            this.minPartitions(model.minPartitions);
        }

        public final String getBootstrapServers() {
            return this.bootstrapServers;
        }

        public final void setBootstrapServers(String bootstrapServers) {
            this.bootstrapServers = bootstrapServers;
        }

        @Override
        public final Builder bootstrapServers(String bootstrapServers) {
            this.bootstrapServers = bootstrapServers;
            return this;
        }

        public final String getSecurityProtocol() {
            return this.securityProtocol;
        }

        public final void setSecurityProtocol(String securityProtocol) {
            this.securityProtocol = securityProtocol;
        }

        @Override
        public final Builder securityProtocol(String securityProtocol) {
            this.securityProtocol = securityProtocol;
            return this;
        }

        public final String getConnectionName() {
            return this.connectionName;
        }

        public final void setConnectionName(String connectionName) {
            this.connectionName = connectionName;
        }

        @Override
        public final Builder connectionName(String connectionName) {
            this.connectionName = connectionName;
            return this;
        }

        public final String getTopicName() {
            return this.topicName;
        }

        public final void setTopicName(String topicName) {
            this.topicName = topicName;
        }

        @Override
        public final Builder topicName(String topicName) {
            this.topicName = topicName;
            return this;
        }

        public final String getAssign() {
            return this.assign;
        }

        public final void setAssign(String assign) {
            this.assign = assign;
        }

        @Override
        public final Builder assign(String assign) {
            this.assign = assign;
            return this;
        }

        public final String getSubscribePattern() {
            return this.subscribePattern;
        }

        public final void setSubscribePattern(String subscribePattern) {
            this.subscribePattern = subscribePattern;
        }

        @Override
        public final Builder subscribePattern(String subscribePattern) {
            this.subscribePattern = subscribePattern;
            return this;
        }

        public final String getClassification() {
            return this.classification;
        }

        public final void setClassification(String classification) {
            this.classification = classification;
        }

        @Override
        public final Builder classification(String classification) {
            this.classification = classification;
            return this;
        }

        public final String getDelimiter() {
            return this.delimiter;
        }

        public final void setDelimiter(String delimiter) {
            this.delimiter = delimiter;
        }

        @Override
        public final Builder delimiter(String delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public final String getStartingOffsets() {
            return this.startingOffsets;
        }

        public final void setStartingOffsets(String startingOffsets) {
            this.startingOffsets = startingOffsets;
        }

        @Override
        public final Builder startingOffsets(String startingOffsets) {
            this.startingOffsets = startingOffsets;
            return this;
        }

        public final String getEndingOffsets() {
            return this.endingOffsets;
        }

        public final void setEndingOffsets(String endingOffsets) {
            this.endingOffsets = endingOffsets;
        }

        @Override
        public final Builder endingOffsets(String endingOffsets) {
            this.endingOffsets = endingOffsets;
            return this;
        }

        public final Long getPollTimeoutMs() {
            return this.pollTimeoutMs;
        }

        public final void setPollTimeoutMs(Long pollTimeoutMs) {
            this.pollTimeoutMs = pollTimeoutMs;
        }

        @Override
        public final Builder pollTimeoutMs(Long pollTimeoutMs) {
            this.pollTimeoutMs = pollTimeoutMs;
            return this;
        }

        public final Integer getNumRetries() {
            return this.numRetries;
        }

        public final void setNumRetries(Integer numRetries) {
            this.numRetries = numRetries;
        }

        @Override
        public final Builder numRetries(Integer numRetries) {
            this.numRetries = numRetries;
            return this;
        }

        public final Long getRetryIntervalMs() {
            return this.retryIntervalMs;
        }

        public final void setRetryIntervalMs(Long retryIntervalMs) {
            this.retryIntervalMs = retryIntervalMs;
        }

        @Override
        public final Builder retryIntervalMs(Long retryIntervalMs) {
            this.retryIntervalMs = retryIntervalMs;
            return this;
        }

        public final Long getMaxOffsetsPerTrigger() {
            return this.maxOffsetsPerTrigger;
        }

        public final void setMaxOffsetsPerTrigger(Long maxOffsetsPerTrigger) {
            this.maxOffsetsPerTrigger = maxOffsetsPerTrigger;
        }

        @Override
        public final Builder maxOffsetsPerTrigger(Long maxOffsetsPerTrigger) {
            this.maxOffsetsPerTrigger = maxOffsetsPerTrigger;
            return this;
        }

        public final Integer getMinPartitions() {
            return this.minPartitions;
        }

        public final void setMinPartitions(Integer minPartitions) {
            this.minPartitions = minPartitions;
        }

        @Override
        public final Builder minPartitions(Integer minPartitions) {
            this.minPartitions = minPartitions;
            return this;
        }

        public KafkaStreamingSourceOptions build() {
            return new KafkaStreamingSourceOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KafkaStreamingSourceOptions> {
        public Builder bootstrapServers(String var1);

        public Builder securityProtocol(String var1);

        public Builder connectionName(String var1);

        public Builder topicName(String var1);

        public Builder assign(String var1);

        public Builder subscribePattern(String var1);

        public Builder classification(String var1);

        public Builder delimiter(String var1);

        public Builder startingOffsets(String var1);

        public Builder endingOffsets(String var1);

        public Builder pollTimeoutMs(Long var1);

        public Builder numRetries(Integer var1);

        public Builder retryIntervalMs(Long var1);

        public Builder maxOffsetsPerTrigger(Long var1);

        public Builder minPartitions(Integer var1);
    }
}

