/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.model.GetPartitionsRequest;
import software.amazon.awssdk.services.glue.model.GetPartitionsResponse;

public class GetPartitionsIterable
implements SdkIterable<GetPartitionsResponse> {
    private final GlueClient client;
    private final GetPartitionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetPartitionsIterable(GlueClient client, GetPartitionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetPartitionsResponseFetcher();
    }

    public Iterator<GetPartitionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetPartitionsResponseFetcher
    implements SyncPageFetcher<GetPartitionsResponse> {
        private GetPartitionsResponseFetcher() {
        }

        public boolean hasNextPage(GetPartitionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetPartitionsResponse nextPage(GetPartitionsResponse previousPage) {
            if (previousPage == null) {
                return GetPartitionsIterable.this.client.getPartitions(GetPartitionsIterable.this.firstRequest);
            }
            return GetPartitionsIterable.this.client.getPartitions((GetPartitionsRequest)((Object)GetPartitionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

