/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.model.GetBlueprintRunsRequest;
import software.amazon.awssdk.services.glue.model.GetBlueprintRunsResponse;

public class GetBlueprintRunsIterable
implements SdkIterable<GetBlueprintRunsResponse> {
    private final GlueClient client;
    private final GetBlueprintRunsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetBlueprintRunsIterable(GlueClient client, GetBlueprintRunsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetBlueprintRunsResponseFetcher();
    }

    public Iterator<GetBlueprintRunsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetBlueprintRunsResponseFetcher
    implements SyncPageFetcher<GetBlueprintRunsResponse> {
        private GetBlueprintRunsResponseFetcher() {
        }

        public boolean hasNextPage(GetBlueprintRunsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetBlueprintRunsResponse nextPage(GetBlueprintRunsResponse previousPage) {
            if (previousPage == null) {
                return GetBlueprintRunsIterable.this.client.getBlueprintRuns(GetBlueprintRunsIterable.this.firstRequest);
            }
            return GetBlueprintRunsIterable.this.client.getBlueprintRuns((GetBlueprintRunsRequest)((Object)GetBlueprintRunsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

