/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glue.GlueAsyncClient;
import software.amazon.awssdk.services.glue.model.GetMlTransformsRequest;
import software.amazon.awssdk.services.glue.model.GetMlTransformsResponse;

public class GetMLTransformsPublisher
implements SdkPublisher<GetMlTransformsResponse> {
    private final GlueAsyncClient client;
    private final GetMlTransformsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetMLTransformsPublisher(GlueAsyncClient client, GetMlTransformsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetMLTransformsPublisher(GlueAsyncClient client, GetMlTransformsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetMlTransformsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetMlTransformsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetMlTransformsResponseFetcher
    implements AsyncPageFetcher<GetMlTransformsResponse> {
        private GetMlTransformsResponseFetcher() {
        }

        public boolean hasNextPage(GetMlTransformsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetMlTransformsResponse> nextPage(GetMlTransformsResponse previousPage) {
            if (previousPage == null) {
                return GetMLTransformsPublisher.this.client.getMLTransforms(GetMLTransformsPublisher.this.firstRequest);
            }
            return GetMLTransformsPublisher.this.client.getMLTransforms((GetMlTransformsRequest)((Object)GetMLTransformsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

