/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SessionCommand
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SessionCommand> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(SessionCommand.getter(SessionCommand::name)).setter(SessionCommand.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> PYTHON_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PythonVersion").getter(SessionCommand.getter(SessionCommand::pythonVersion)).setter(SessionCommand.setter(Builder::pythonVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PythonVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, PYTHON_VERSION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String pythonVersion;

    private SessionCommand(BuilderImpl builder) {
        this.name = builder.name;
        this.pythonVersion = builder.pythonVersion;
    }

    public final String name() {
        return this.name;
    }

    public final String pythonVersion() {
        return this.pythonVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.pythonVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SessionCommand)) {
            return false;
        }
        SessionCommand other = (SessionCommand)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.pythonVersion(), other.pythonVersion());
    }

    public final String toString() {
        return ToString.builder((String)"SessionCommand").add("Name", (Object)this.name()).add("PythonVersion", (Object)this.pythonVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "PythonVersion": {
                return Optional.ofNullable(clazz.cast(this.pythonVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SessionCommand, T> g) {
        return obj -> g.apply((SessionCommand)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String pythonVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(SessionCommand model) {
            this.name(model.name);
            this.pythonVersion(model.pythonVersion);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getPythonVersion() {
            return this.pythonVersion;
        }

        public final void setPythonVersion(String pythonVersion) {
            this.pythonVersion = pythonVersion;
        }

        @Override
        @Transient
        public final Builder pythonVersion(String pythonVersion) {
            this.pythonVersion = pythonVersion;
            return this;
        }

        public SessionCommand build() {
            return new SessionCommand(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SessionCommand> {
        public Builder name(String var1);

        public Builder pythonVersion(String var1);
    }
}

