/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.glue.model.ConnectionsList;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.services.glue.model.OrchestrationArgumentsMapCopier;
import software.amazon.awssdk.services.glue.model.SessionCommand;
import software.amazon.awssdk.services.glue.model.TagsMapCopier;
import software.amazon.awssdk.services.glue.model.WorkerType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateSessionRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, CreateSessionRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(CreateSessionRequest.getter(CreateSessionRequest::id)).setter(CreateSessionRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateSessionRequest.getter(CreateSessionRequest::description)).setter(CreateSessionRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Role").getter(CreateSessionRequest.getter(CreateSessionRequest::role)).setter(CreateSessionRequest.setter(Builder::role)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()}).build();
    private static final SdkField<SessionCommand> COMMAND_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Command").getter(CreateSessionRequest.getter(CreateSessionRequest::command)).setter(CreateSessionRequest.setter(Builder::command)).constructor(SessionCommand::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Command").build()}).build();
    private static final SdkField<Integer> TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Timeout").getter(CreateSessionRequest.getter(CreateSessionRequest::timeout)).setter(CreateSessionRequest.setter(Builder::timeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timeout").build()}).build();
    private static final SdkField<Integer> IDLE_TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("IdleTimeout").getter(CreateSessionRequest.getter(CreateSessionRequest::idleTimeout)).setter(CreateSessionRequest.setter(Builder::idleTimeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdleTimeout").build()}).build();
    private static final SdkField<Map<String, String>> DEFAULT_ARGUMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("DefaultArguments").getter(CreateSessionRequest.getter(CreateSessionRequest::defaultArguments)).setter(CreateSessionRequest.setter(Builder::defaultArguments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultArguments").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<ConnectionsList> CONNECTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Connections").getter(CreateSessionRequest.getter(CreateSessionRequest::connections)).setter(CreateSessionRequest.setter(Builder::connections)).constructor(ConnectionsList::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Connections").build()}).build();
    private static final SdkField<Double> MAX_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("MaxCapacity").getter(CreateSessionRequest.getter(CreateSessionRequest::maxCapacity)).setter(CreateSessionRequest.setter(Builder::maxCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxCapacity").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_WORKERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfWorkers").getter(CreateSessionRequest.getter(CreateSessionRequest::numberOfWorkers)).setter(CreateSessionRequest.setter(Builder::numberOfWorkers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfWorkers").build()}).build();
    private static final SdkField<String> WORKER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkerType").getter(CreateSessionRequest.getter(CreateSessionRequest::workerTypeAsString)).setter(CreateSessionRequest.setter(Builder::workerType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkerType").build()}).build();
    private static final SdkField<String> SECURITY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecurityConfiguration").getter(CreateSessionRequest.getter(CreateSessionRequest::securityConfiguration)).setter(CreateSessionRequest.setter(Builder::securityConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityConfiguration").build()}).build();
    private static final SdkField<String> GLUE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GlueVersion").getter(CreateSessionRequest.getter(CreateSessionRequest::glueVersion)).setter(CreateSessionRequest.setter(Builder::glueVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlueVersion").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateSessionRequest.getter(CreateSessionRequest::tags)).setter(CreateSessionRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> REQUEST_ORIGIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestOrigin").getter(CreateSessionRequest.getter(CreateSessionRequest::requestOrigin)).setter(CreateSessionRequest.setter(Builder::requestOrigin)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestOrigin").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, DESCRIPTION_FIELD, ROLE_FIELD, COMMAND_FIELD, TIMEOUT_FIELD, IDLE_TIMEOUT_FIELD, DEFAULT_ARGUMENTS_FIELD, CONNECTIONS_FIELD, MAX_CAPACITY_FIELD, NUMBER_OF_WORKERS_FIELD, WORKER_TYPE_FIELD, SECURITY_CONFIGURATION_FIELD, GLUE_VERSION_FIELD, TAGS_FIELD, REQUEST_ORIGIN_FIELD));
    private final String id;
    private final String description;
    private final String role;
    private final SessionCommand command;
    private final Integer timeout;
    private final Integer idleTimeout;
    private final Map<String, String> defaultArguments;
    private final ConnectionsList connections;
    private final Double maxCapacity;
    private final Integer numberOfWorkers;
    private final String workerType;
    private final String securityConfiguration;
    private final String glueVersion;
    private final Map<String, String> tags;
    private final String requestOrigin;

    private CreateSessionRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.description = builder.description;
        this.role = builder.role;
        this.command = builder.command;
        this.timeout = builder.timeout;
        this.idleTimeout = builder.idleTimeout;
        this.defaultArguments = builder.defaultArguments;
        this.connections = builder.connections;
        this.maxCapacity = builder.maxCapacity;
        this.numberOfWorkers = builder.numberOfWorkers;
        this.workerType = builder.workerType;
        this.securityConfiguration = builder.securityConfiguration;
        this.glueVersion = builder.glueVersion;
        this.tags = builder.tags;
        this.requestOrigin = builder.requestOrigin;
    }

    public final String id() {
        return this.id;
    }

    public final String description() {
        return this.description;
    }

    public final String role() {
        return this.role;
    }

    public final SessionCommand command() {
        return this.command;
    }

    public final Integer timeout() {
        return this.timeout;
    }

    public final Integer idleTimeout() {
        return this.idleTimeout;
    }

    public final boolean hasDefaultArguments() {
        return this.defaultArguments != null && !(this.defaultArguments instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> defaultArguments() {
        return this.defaultArguments;
    }

    public final ConnectionsList connections() {
        return this.connections;
    }

    public final Double maxCapacity() {
        return this.maxCapacity;
    }

    public final Integer numberOfWorkers() {
        return this.numberOfWorkers;
    }

    public final WorkerType workerType() {
        return WorkerType.fromValue(this.workerType);
    }

    public final String workerTypeAsString() {
        return this.workerType;
    }

    public final String securityConfiguration() {
        return this.securityConfiguration;
    }

    public final String glueVersion() {
        return this.glueVersion;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String requestOrigin() {
        return this.requestOrigin;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.role());
        hashCode = 31 * hashCode + Objects.hashCode(this.command());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.idleTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDefaultArguments() ? this.defaultArguments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.connections());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfWorkers());
        hashCode = 31 * hashCode + Objects.hashCode(this.workerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.glueVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.requestOrigin());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSessionRequest)) {
            return false;
        }
        CreateSessionRequest other = (CreateSessionRequest)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.role(), other.role()) && Objects.equals(this.command(), other.command()) && Objects.equals(this.timeout(), other.timeout()) && Objects.equals(this.idleTimeout(), other.idleTimeout()) && this.hasDefaultArguments() == other.hasDefaultArguments() && Objects.equals(this.defaultArguments(), other.defaultArguments()) && Objects.equals(this.connections(), other.connections()) && Objects.equals(this.maxCapacity(), other.maxCapacity()) && Objects.equals(this.numberOfWorkers(), other.numberOfWorkers()) && Objects.equals(this.workerTypeAsString(), other.workerTypeAsString()) && Objects.equals(this.securityConfiguration(), other.securityConfiguration()) && Objects.equals(this.glueVersion(), other.glueVersion()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.requestOrigin(), other.requestOrigin());
    }

    public final String toString() {
        return ToString.builder((String)"CreateSessionRequest").add("Id", (Object)this.id()).add("Description", (Object)this.description()).add("Role", (Object)this.role()).add("Command", (Object)this.command()).add("Timeout", (Object)this.timeout()).add("IdleTimeout", (Object)this.idleTimeout()).add("DefaultArguments", this.hasDefaultArguments() ? this.defaultArguments() : null).add("Connections", (Object)this.connections()).add("MaxCapacity", (Object)this.maxCapacity()).add("NumberOfWorkers", (Object)this.numberOfWorkers()).add("WorkerType", (Object)this.workerTypeAsString()).add("SecurityConfiguration", (Object)this.securityConfiguration()).add("GlueVersion", (Object)this.glueVersion()).add("Tags", this.hasTags() ? this.tags() : null).add("RequestOrigin", (Object)this.requestOrigin()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Role": {
                return Optional.ofNullable(clazz.cast(this.role()));
            }
            case "Command": {
                return Optional.ofNullable(clazz.cast(this.command()));
            }
            case "Timeout": {
                return Optional.ofNullable(clazz.cast(this.timeout()));
            }
            case "IdleTimeout": {
                return Optional.ofNullable(clazz.cast(this.idleTimeout()));
            }
            case "DefaultArguments": {
                return Optional.ofNullable(clazz.cast(this.defaultArguments()));
            }
            case "Connections": {
                return Optional.ofNullable(clazz.cast(this.connections()));
            }
            case "MaxCapacity": {
                return Optional.ofNullable(clazz.cast(this.maxCapacity()));
            }
            case "NumberOfWorkers": {
                return Optional.ofNullable(clazz.cast(this.numberOfWorkers()));
            }
            case "WorkerType": {
                return Optional.ofNullable(clazz.cast(this.workerTypeAsString()));
            }
            case "SecurityConfiguration": {
                return Optional.ofNullable(clazz.cast(this.securityConfiguration()));
            }
            case "GlueVersion": {
                return Optional.ofNullable(clazz.cast(this.glueVersion()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "RequestOrigin": {
                return Optional.ofNullable(clazz.cast(this.requestOrigin()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSessionRequest, T> g) {
        return obj -> g.apply((CreateSessionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String id;
        private String description;
        private String role;
        private SessionCommand command;
        private Integer timeout;
        private Integer idleTimeout;
        private Map<String, String> defaultArguments = DefaultSdkAutoConstructMap.getInstance();
        private ConnectionsList connections;
        private Double maxCapacity;
        private Integer numberOfWorkers;
        private String workerType;
        private String securityConfiguration;
        private String glueVersion;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String requestOrigin;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSessionRequest model) {
            super(model);
            this.id(model.id);
            this.description(model.description);
            this.role(model.role);
            this.command(model.command);
            this.timeout(model.timeout);
            this.idleTimeout(model.idleTimeout);
            this.defaultArguments(model.defaultArguments);
            this.connections(model.connections);
            this.maxCapacity(model.maxCapacity);
            this.numberOfWorkers(model.numberOfWorkers);
            this.workerType(model.workerType);
            this.securityConfiguration(model.securityConfiguration);
            this.glueVersion(model.glueVersion);
            this.tags(model.tags);
            this.requestOrigin(model.requestOrigin);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getRole() {
            return this.role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        @Transient
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final SessionCommand.Builder getCommand() {
            return this.command != null ? this.command.toBuilder() : null;
        }

        public final void setCommand(SessionCommand.BuilderImpl command) {
            this.command = command != null ? command.build() : null;
        }

        @Override
        @Transient
        public final Builder command(SessionCommand command) {
            this.command = command;
            return this;
        }

        public final Integer getTimeout() {
            return this.timeout;
        }

        public final void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        @Override
        @Transient
        public final Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public final Integer getIdleTimeout() {
            return this.idleTimeout;
        }

        public final void setIdleTimeout(Integer idleTimeout) {
            this.idleTimeout = idleTimeout;
        }

        @Override
        @Transient
        public final Builder idleTimeout(Integer idleTimeout) {
            this.idleTimeout = idleTimeout;
            return this;
        }

        public final Map<String, String> getDefaultArguments() {
            if (this.defaultArguments instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.defaultArguments;
        }

        public final void setDefaultArguments(Map<String, String> defaultArguments) {
            this.defaultArguments = OrchestrationArgumentsMapCopier.copy(defaultArguments);
        }

        @Override
        @Transient
        public final Builder defaultArguments(Map<String, String> defaultArguments) {
            this.defaultArguments = OrchestrationArgumentsMapCopier.copy(defaultArguments);
            return this;
        }

        public final ConnectionsList.Builder getConnections() {
            return this.connections != null ? this.connections.toBuilder() : null;
        }

        public final void setConnections(ConnectionsList.BuilderImpl connections) {
            this.connections = connections != null ? connections.build() : null;
        }

        @Override
        @Transient
        public final Builder connections(ConnectionsList connections) {
            this.connections = connections;
            return this;
        }

        public final Double getMaxCapacity() {
            return this.maxCapacity;
        }

        public final void setMaxCapacity(Double maxCapacity) {
            this.maxCapacity = maxCapacity;
        }

        @Override
        @Transient
        public final Builder maxCapacity(Double maxCapacity) {
            this.maxCapacity = maxCapacity;
            return this;
        }

        public final Integer getNumberOfWorkers() {
            return this.numberOfWorkers;
        }

        public final void setNumberOfWorkers(Integer numberOfWorkers) {
            this.numberOfWorkers = numberOfWorkers;
        }

        @Override
        @Transient
        public final Builder numberOfWorkers(Integer numberOfWorkers) {
            this.numberOfWorkers = numberOfWorkers;
            return this;
        }

        public final String getWorkerType() {
            return this.workerType;
        }

        public final void setWorkerType(String workerType) {
            this.workerType = workerType;
        }

        @Override
        @Transient
        public final Builder workerType(String workerType) {
            this.workerType = workerType;
            return this;
        }

        @Override
        @Transient
        public final Builder workerType(WorkerType workerType) {
            this.workerType(workerType == null ? null : workerType.toString());
            return this;
        }

        public final String getSecurityConfiguration() {
            return this.securityConfiguration;
        }

        public final void setSecurityConfiguration(String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
        }

        @Override
        @Transient
        public final Builder securityConfiguration(String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
            return this;
        }

        public final String getGlueVersion() {
            return this.glueVersion;
        }

        public final void setGlueVersion(String glueVersion) {
            this.glueVersion = glueVersion;
        }

        @Override
        @Transient
        public final Builder glueVersion(String glueVersion) {
            this.glueVersion = glueVersion;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final String getRequestOrigin() {
            return this.requestOrigin;
        }

        public final void setRequestOrigin(String requestOrigin) {
            this.requestOrigin = requestOrigin;
        }

        @Override
        @Transient
        public final Builder requestOrigin(String requestOrigin) {
            this.requestOrigin = requestOrigin;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSessionRequest build() {
            return new CreateSessionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateSessionRequest> {
        public Builder id(String var1);

        public Builder description(String var1);

        public Builder role(String var1);

        public Builder command(SessionCommand var1);

        default public Builder command(Consumer<SessionCommand.Builder> command) {
            return this.command((SessionCommand)((SessionCommand.Builder)SessionCommand.builder().applyMutation(command)).build());
        }

        public Builder timeout(Integer var1);

        public Builder idleTimeout(Integer var1);

        public Builder defaultArguments(Map<String, String> var1);

        public Builder connections(ConnectionsList var1);

        default public Builder connections(Consumer<ConnectionsList.Builder> connections) {
            return this.connections((ConnectionsList)((ConnectionsList.Builder)ConnectionsList.builder().applyMutation(connections)).build());
        }

        public Builder maxCapacity(Double var1);

        public Builder numberOfWorkers(Integer var1);

        public Builder workerType(String var1);

        public Builder workerType(WorkerType var1);

        public Builder securityConfiguration(String var1);

        public Builder glueVersion(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder requestOrigin(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

