/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateScriptResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, CreateScriptResponse> {
    private static final SdkField<String> PYTHON_SCRIPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PythonScript").getter(CreateScriptResponse.getter(CreateScriptResponse::pythonScript)).setter(CreateScriptResponse.setter(Builder::pythonScript)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PythonScript").build()}).build();
    private static final SdkField<String> SCALA_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScalaCode").getter(CreateScriptResponse.getter(CreateScriptResponse::scalaCode)).setter(CreateScriptResponse.setter(Builder::scalaCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalaCode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PYTHON_SCRIPT_FIELD, SCALA_CODE_FIELD));
    private final String pythonScript;
    private final String scalaCode;

    private CreateScriptResponse(BuilderImpl builder) {
        super(builder);
        this.pythonScript = builder.pythonScript;
        this.scalaCode = builder.scalaCode;
    }

    public final String pythonScript() {
        return this.pythonScript;
    }

    public final String scalaCode() {
        return this.scalaCode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.pythonScript());
        hashCode = 31 * hashCode + Objects.hashCode(this.scalaCode());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateScriptResponse)) {
            return false;
        }
        CreateScriptResponse other = (CreateScriptResponse)((Object)obj);
        return Objects.equals(this.pythonScript(), other.pythonScript()) && Objects.equals(this.scalaCode(), other.scalaCode());
    }

    public final String toString() {
        return ToString.builder((String)"CreateScriptResponse").add("PythonScript", (Object)this.pythonScript()).add("ScalaCode", (Object)this.scalaCode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PythonScript": {
                return Optional.ofNullable(clazz.cast(this.pythonScript()));
            }
            case "ScalaCode": {
                return Optional.ofNullable(clazz.cast(this.scalaCode()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateScriptResponse, T> g) {
        return obj -> g.apply((CreateScriptResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private String pythonScript;
        private String scalaCode;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateScriptResponse model) {
            super(model);
            this.pythonScript(model.pythonScript);
            this.scalaCode(model.scalaCode);
        }

        public final String getPythonScript() {
            return this.pythonScript;
        }

        public final void setPythonScript(String pythonScript) {
            this.pythonScript = pythonScript;
        }

        @Override
        @Transient
        public final Builder pythonScript(String pythonScript) {
            this.pythonScript = pythonScript;
            return this;
        }

        public final String getScalaCode() {
            return this.scalaCode;
        }

        public final void setScalaCode(String scalaCode) {
            this.scalaCode = scalaCode;
        }

        @Override
        @Transient
        public final Builder scalaCode(String scalaCode) {
            this.scalaCode = scalaCode;
            return this;
        }

        @Override
        public CreateScriptResponse build() {
            return new CreateScriptResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateScriptResponse> {
        public Builder pythonScript(String var1);

        public Builder scalaCode(String var1);
    }
}

