/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.SecurityGroupIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PhysicalConnectionRequirements
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PhysicalConnectionRequirements> {
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetId").getter(PhysicalConnectionRequirements.getter(PhysicalConnectionRequirements::subnetId)).setter(PhysicalConnectionRequirements.setter(Builder::subnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_ID_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroupIdList").getter(PhysicalConnectionRequirements.getter(PhysicalConnectionRequirements::securityGroupIdList)).setter(PhysicalConnectionRequirements.setter(Builder::securityGroupIdList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIdList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(PhysicalConnectionRequirements.getter(PhysicalConnectionRequirements::availabilityZone)).setter(PhysicalConnectionRequirements.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBNET_ID_FIELD, SECURITY_GROUP_ID_LIST_FIELD, AVAILABILITY_ZONE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String subnetId;
    private final List<String> securityGroupIdList;
    private final String availabilityZone;

    private PhysicalConnectionRequirements(BuilderImpl builder) {
        this.subnetId = builder.subnetId;
        this.securityGroupIdList = builder.securityGroupIdList;
        this.availabilityZone = builder.availabilityZone;
    }

    public final String subnetId() {
        return this.subnetId;
    }

    public final boolean hasSecurityGroupIdList() {
        return this.securityGroupIdList != null && !(this.securityGroupIdList instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroupIdList() {
        return this.securityGroupIdList;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroupIdList() ? this.securityGroupIdList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PhysicalConnectionRequirements)) {
            return false;
        }
        PhysicalConnectionRequirements other = (PhysicalConnectionRequirements)obj;
        return Objects.equals(this.subnetId(), other.subnetId()) && this.hasSecurityGroupIdList() == other.hasSecurityGroupIdList() && Objects.equals(this.securityGroupIdList(), other.securityGroupIdList()) && Objects.equals(this.availabilityZone(), other.availabilityZone());
    }

    public final String toString() {
        return ToString.builder((String)"PhysicalConnectionRequirements").add("SubnetId", (Object)this.subnetId()).add("SecurityGroupIdList", this.hasSecurityGroupIdList() ? this.securityGroupIdList() : null).add("AvailabilityZone", (Object)this.availabilityZone()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SubnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
            case "SecurityGroupIdList": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIdList()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PhysicalConnectionRequirements, T> g) {
        return obj -> g.apply((PhysicalConnectionRequirements)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String subnetId;
        private List<String> securityGroupIdList = DefaultSdkAutoConstructList.getInstance();
        private String availabilityZone;

        private BuilderImpl() {
        }

        private BuilderImpl(PhysicalConnectionRequirements model) {
            this.subnetId(model.subnetId);
            this.securityGroupIdList(model.securityGroupIdList);
            this.availabilityZone(model.availabilityZone);
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        @Transient
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final Collection<String> getSecurityGroupIdList() {
            if (this.securityGroupIdList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroupIdList;
        }

        public final void setSecurityGroupIdList(Collection<String> securityGroupIdList) {
            this.securityGroupIdList = SecurityGroupIdListCopier.copy(securityGroupIdList);
        }

        @Override
        @Transient
        public final Builder securityGroupIdList(Collection<String> securityGroupIdList) {
            this.securityGroupIdList = SecurityGroupIdListCopier.copy(securityGroupIdList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder securityGroupIdList(String ... securityGroupIdList) {
            this.securityGroupIdList(Arrays.asList(securityGroupIdList));
            return this;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        @Transient
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public PhysicalConnectionRequirements build() {
            return new PhysicalConnectionRequirements(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PhysicalConnectionRequirements> {
        public Builder subnetId(String var1);

        public Builder securityGroupIdList(Collection<String> var1);

        public Builder securityGroupIdList(String ... var1);

        public Builder availabilityZone(String var1);
    }
}

