/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.SchemaStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SchemaListItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SchemaListItem> {
    private static final SdkField<String> REGISTRY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegistryName").getter(SchemaListItem.getter(SchemaListItem::registryName)).setter(SchemaListItem.setter(Builder::registryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistryName").build()}).build();
    private static final SdkField<String> SCHEMA_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SchemaName").getter(SchemaListItem.getter(SchemaListItem::schemaName)).setter(SchemaListItem.setter(Builder::schemaName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaName").build()}).build();
    private static final SdkField<String> SCHEMA_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SchemaArn").getter(SchemaListItem.getter(SchemaListItem::schemaArn)).setter(SchemaListItem.setter(Builder::schemaArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaArn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(SchemaListItem.getter(SchemaListItem::description)).setter(SchemaListItem.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> SCHEMA_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SchemaStatus").getter(SchemaListItem.getter(SchemaListItem::schemaStatusAsString)).setter(SchemaListItem.setter(Builder::schemaStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaStatus").build()}).build();
    private static final SdkField<String> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatedTime").getter(SchemaListItem.getter(SchemaListItem::createdTime)).setter(SchemaListItem.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<String> UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UpdatedTime").getter(SchemaListItem.getter(SchemaListItem::updatedTime)).setter(SchemaListItem.setter(Builder::updatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRY_NAME_FIELD, SCHEMA_NAME_FIELD, SCHEMA_ARN_FIELD, DESCRIPTION_FIELD, SCHEMA_STATUS_FIELD, CREATED_TIME_FIELD, UPDATED_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String registryName;
    private final String schemaName;
    private final String schemaArn;
    private final String description;
    private final String schemaStatus;
    private final String createdTime;
    private final String updatedTime;

    private SchemaListItem(BuilderImpl builder) {
        this.registryName = builder.registryName;
        this.schemaName = builder.schemaName;
        this.schemaArn = builder.schemaArn;
        this.description = builder.description;
        this.schemaStatus = builder.schemaStatus;
        this.createdTime = builder.createdTime;
        this.updatedTime = builder.updatedTime;
    }

    public final String registryName() {
        return this.registryName;
    }

    public final String schemaName() {
        return this.schemaName;
    }

    public final String schemaArn() {
        return this.schemaArn;
    }

    public final String description() {
        return this.description;
    }

    public final SchemaStatus schemaStatus() {
        return SchemaStatus.fromValue(this.schemaStatus);
    }

    public final String schemaStatusAsString() {
        return this.schemaStatus;
    }

    public final String createdTime() {
        return this.createdTime;
    }

    public final String updatedTime() {
        return this.updatedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.registryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaName());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SchemaListItem)) {
            return false;
        }
        SchemaListItem other = (SchemaListItem)obj;
        return Objects.equals(this.registryName(), other.registryName()) && Objects.equals(this.schemaName(), other.schemaName()) && Objects.equals(this.schemaArn(), other.schemaArn()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.schemaStatusAsString(), other.schemaStatusAsString()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.updatedTime(), other.updatedTime());
    }

    public final String toString() {
        return ToString.builder((String)"SchemaListItem").add("RegistryName", (Object)this.registryName()).add("SchemaName", (Object)this.schemaName()).add("SchemaArn", (Object)this.schemaArn()).add("Description", (Object)this.description()).add("SchemaStatus", (Object)this.schemaStatusAsString()).add("CreatedTime", (Object)this.createdTime()).add("UpdatedTime", (Object)this.updatedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RegistryName": {
                return Optional.ofNullable(clazz.cast(this.registryName()));
            }
            case "SchemaName": {
                return Optional.ofNullable(clazz.cast(this.schemaName()));
            }
            case "SchemaArn": {
                return Optional.ofNullable(clazz.cast(this.schemaArn()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "SchemaStatus": {
                return Optional.ofNullable(clazz.cast(this.schemaStatusAsString()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "UpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.updatedTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SchemaListItem, T> g) {
        return obj -> g.apply((SchemaListItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String registryName;
        private String schemaName;
        private String schemaArn;
        private String description;
        private String schemaStatus;
        private String createdTime;
        private String updatedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(SchemaListItem model) {
            this.registryName(model.registryName);
            this.schemaName(model.schemaName);
            this.schemaArn(model.schemaArn);
            this.description(model.description);
            this.schemaStatus(model.schemaStatus);
            this.createdTime(model.createdTime);
            this.updatedTime(model.updatedTime);
        }

        public final String getRegistryName() {
            return this.registryName;
        }

        public final void setRegistryName(String registryName) {
            this.registryName = registryName;
        }

        @Override
        @Transient
        public final Builder registryName(String registryName) {
            this.registryName = registryName;
            return this;
        }

        public final String getSchemaName() {
            return this.schemaName;
        }

        public final void setSchemaName(String schemaName) {
            this.schemaName = schemaName;
        }

        @Override
        @Transient
        public final Builder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public final String getSchemaArn() {
            return this.schemaArn;
        }

        public final void setSchemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
        }

        @Override
        @Transient
        public final Builder schemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getSchemaStatus() {
            return this.schemaStatus;
        }

        public final void setSchemaStatus(String schemaStatus) {
            this.schemaStatus = schemaStatus;
        }

        @Override
        @Transient
        public final Builder schemaStatus(String schemaStatus) {
            this.schemaStatus = schemaStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder schemaStatus(SchemaStatus schemaStatus) {
            this.schemaStatus(schemaStatus == null ? null : schemaStatus.toString());
            return this;
        }

        public final String getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(String createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        @Transient
        public final Builder createdTime(String createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getUpdatedTime() {
            return this.updatedTime;
        }

        public final void setUpdatedTime(String updatedTime) {
            this.updatedTime = updatedTime;
        }

        @Override
        @Transient
        public final Builder updatedTime(String updatedTime) {
            this.updatedTime = updatedTime;
            return this;
        }

        public SchemaListItem build() {
            return new SchemaListItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SchemaListItem> {
        public Builder registryName(String var1);

        public Builder schemaName(String var1);

        public Builder schemaArn(String var1);

        public Builder description(String var1);

        public Builder schemaStatus(String var1);

        public Builder schemaStatus(SchemaStatus var1);

        public Builder createdTime(String var1);

        public Builder updatedTime(String var1);
    }
}

