/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.CsvClassifier;
import software.amazon.awssdk.services.glue.model.GrokClassifier;
import software.amazon.awssdk.services.glue.model.JsonClassifier;
import software.amazon.awssdk.services.glue.model.XMLClassifier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Classifier
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Classifier> {
    private static final SdkField<GrokClassifier> GROK_CLASSIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("GrokClassifier").getter(Classifier.getter(Classifier::grokClassifier)).setter(Classifier.setter(Builder::grokClassifier)).constructor(GrokClassifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrokClassifier").build()}).build();
    private static final SdkField<XMLClassifier> XML_CLASSIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("XMLClassifier").getter(Classifier.getter(Classifier::xmlClassifier)).setter(Classifier.setter(Builder::xmlClassifier)).constructor(XMLClassifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("XMLClassifier").build()}).build();
    private static final SdkField<JsonClassifier> JSON_CLASSIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("JsonClassifier").getter(Classifier.getter(Classifier::jsonClassifier)).setter(Classifier.setter(Builder::jsonClassifier)).constructor(JsonClassifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JsonClassifier").build()}).build();
    private static final SdkField<CsvClassifier> CSV_CLASSIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CsvClassifier").getter(Classifier.getter(Classifier::csvClassifier)).setter(Classifier.setter(Builder::csvClassifier)).constructor(CsvClassifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CsvClassifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROK_CLASSIFIER_FIELD, XML_CLASSIFIER_FIELD, JSON_CLASSIFIER_FIELD, CSV_CLASSIFIER_FIELD));
    private static final long serialVersionUID = 1L;
    private final GrokClassifier grokClassifier;
    private final XMLClassifier xmlClassifier;
    private final JsonClassifier jsonClassifier;
    private final CsvClassifier csvClassifier;

    private Classifier(BuilderImpl builder) {
        this.grokClassifier = builder.grokClassifier;
        this.xmlClassifier = builder.xmlClassifier;
        this.jsonClassifier = builder.jsonClassifier;
        this.csvClassifier = builder.csvClassifier;
    }

    public final GrokClassifier grokClassifier() {
        return this.grokClassifier;
    }

    public final XMLClassifier xmlClassifier() {
        return this.xmlClassifier;
    }

    public final JsonClassifier jsonClassifier() {
        return this.jsonClassifier;
    }

    public final CsvClassifier csvClassifier() {
        return this.csvClassifier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.grokClassifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.xmlClassifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.jsonClassifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.csvClassifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Classifier)) {
            return false;
        }
        Classifier other = (Classifier)obj;
        return Objects.equals(this.grokClassifier(), other.grokClassifier()) && Objects.equals(this.xmlClassifier(), other.xmlClassifier()) && Objects.equals(this.jsonClassifier(), other.jsonClassifier()) && Objects.equals(this.csvClassifier(), other.csvClassifier());
    }

    public final String toString() {
        return ToString.builder((String)"Classifier").add("GrokClassifier", (Object)this.grokClassifier()).add("XMLClassifier", (Object)this.xmlClassifier()).add("JsonClassifier", (Object)this.jsonClassifier()).add("CsvClassifier", (Object)this.csvClassifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GrokClassifier": {
                return Optional.ofNullable(clazz.cast(this.grokClassifier()));
            }
            case "XMLClassifier": {
                return Optional.ofNullable(clazz.cast(this.xmlClassifier()));
            }
            case "JsonClassifier": {
                return Optional.ofNullable(clazz.cast(this.jsonClassifier()));
            }
            case "CsvClassifier": {
                return Optional.ofNullable(clazz.cast(this.csvClassifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Classifier, T> g) {
        return obj -> g.apply((Classifier)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private GrokClassifier grokClassifier;
        private XMLClassifier xmlClassifier;
        private JsonClassifier jsonClassifier;
        private CsvClassifier csvClassifier;

        private BuilderImpl() {
        }

        private BuilderImpl(Classifier model) {
            this.grokClassifier(model.grokClassifier);
            this.xmlClassifier(model.xmlClassifier);
            this.jsonClassifier(model.jsonClassifier);
            this.csvClassifier(model.csvClassifier);
        }

        public final GrokClassifier.Builder getGrokClassifier() {
            return this.grokClassifier != null ? this.grokClassifier.toBuilder() : null;
        }

        public final void setGrokClassifier(GrokClassifier.BuilderImpl grokClassifier) {
            this.grokClassifier = grokClassifier != null ? grokClassifier.build() : null;
        }

        @Override
        @Transient
        public final Builder grokClassifier(GrokClassifier grokClassifier) {
            this.grokClassifier = grokClassifier;
            return this;
        }

        public final XMLClassifier.Builder getXmlClassifier() {
            return this.xmlClassifier != null ? this.xmlClassifier.toBuilder() : null;
        }

        public final void setXmlClassifier(XMLClassifier.BuilderImpl xmlClassifier) {
            this.xmlClassifier = xmlClassifier != null ? xmlClassifier.build() : null;
        }

        @Override
        @Transient
        public final Builder xmlClassifier(XMLClassifier xmlClassifier) {
            this.xmlClassifier = xmlClassifier;
            return this;
        }

        public final JsonClassifier.Builder getJsonClassifier() {
            return this.jsonClassifier != null ? this.jsonClassifier.toBuilder() : null;
        }

        public final void setJsonClassifier(JsonClassifier.BuilderImpl jsonClassifier) {
            this.jsonClassifier = jsonClassifier != null ? jsonClassifier.build() : null;
        }

        @Override
        @Transient
        public final Builder jsonClassifier(JsonClassifier jsonClassifier) {
            this.jsonClassifier = jsonClassifier;
            return this;
        }

        public final CsvClassifier.Builder getCsvClassifier() {
            return this.csvClassifier != null ? this.csvClassifier.toBuilder() : null;
        }

        public final void setCsvClassifier(CsvClassifier.BuilderImpl csvClassifier) {
            this.csvClassifier = csvClassifier != null ? csvClassifier.build() : null;
        }

        @Override
        @Transient
        public final Builder csvClassifier(CsvClassifier csvClassifier) {
            this.csvClassifier = csvClassifier;
            return this;
        }

        public Classifier build() {
            return new Classifier(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Classifier> {
        public Builder grokClassifier(GrokClassifier var1);

        default public Builder grokClassifier(Consumer<GrokClassifier.Builder> grokClassifier) {
            return this.grokClassifier((GrokClassifier)((GrokClassifier.Builder)GrokClassifier.builder().applyMutation(grokClassifier)).build());
        }

        public Builder xmlClassifier(XMLClassifier var1);

        default public Builder xmlClassifier(Consumer<XMLClassifier.Builder> xmlClassifier) {
            return this.xmlClassifier((XMLClassifier)((XMLClassifier.Builder)XMLClassifier.builder().applyMutation(xmlClassifier)).build());
        }

        public Builder jsonClassifier(JsonClassifier var1);

        default public Builder jsonClassifier(Consumer<JsonClassifier.Builder> jsonClassifier) {
            return this.jsonClassifier((JsonClassifier)((JsonClassifier.Builder)JsonClassifier.builder().applyMutation(jsonClassifier)).build());
        }

        public Builder csvClassifier(CsvClassifier var1);

        default public Builder csvClassifier(Consumer<CsvClassifier.Builder> csvClassifier) {
            return this.csvClassifier((CsvClassifier)((CsvClassifier.Builder)CsvClassifier.builder().applyMutation(csvClassifier)).build());
        }
    }
}

