/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.Crawler;
import software.amazon.awssdk.services.glue.model.CrawlerListCopier;
import software.amazon.awssdk.services.glue.model.CrawlerNameListCopier;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetCrawlersResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, BatchGetCrawlersResponse> {
    private static final SdkField<List<Crawler>> CRAWLERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Crawlers").getter(BatchGetCrawlersResponse.getter(BatchGetCrawlersResponse::crawlers)).setter(BatchGetCrawlersResponse.setter(Builder::crawlers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Crawlers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Crawler::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> CRAWLERS_NOT_FOUND_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CrawlersNotFound").getter(BatchGetCrawlersResponse.getter(BatchGetCrawlersResponse::crawlersNotFound)).setter(BatchGetCrawlersResponse.setter(Builder::crawlersNotFound)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrawlersNotFound").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CRAWLERS_FIELD, CRAWLERS_NOT_FOUND_FIELD));
    private final List<Crawler> crawlers;
    private final List<String> crawlersNotFound;

    private BatchGetCrawlersResponse(BuilderImpl builder) {
        super(builder);
        this.crawlers = builder.crawlers;
        this.crawlersNotFound = builder.crawlersNotFound;
    }

    public final boolean hasCrawlers() {
        return this.crawlers != null && !(this.crawlers instanceof SdkAutoConstructList);
    }

    public final List<Crawler> crawlers() {
        return this.crawlers;
    }

    public final boolean hasCrawlersNotFound() {
        return this.crawlersNotFound != null && !(this.crawlersNotFound instanceof SdkAutoConstructList);
    }

    public final List<String> crawlersNotFound() {
        return this.crawlersNotFound;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCrawlers() ? this.crawlers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCrawlersNotFound() ? this.crawlersNotFound() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetCrawlersResponse)) {
            return false;
        }
        BatchGetCrawlersResponse other = (BatchGetCrawlersResponse)((Object)obj);
        return this.hasCrawlers() == other.hasCrawlers() && Objects.equals(this.crawlers(), other.crawlers()) && this.hasCrawlersNotFound() == other.hasCrawlersNotFound() && Objects.equals(this.crawlersNotFound(), other.crawlersNotFound());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetCrawlersResponse").add("Crawlers", this.hasCrawlers() ? this.crawlers() : null).add("CrawlersNotFound", this.hasCrawlersNotFound() ? this.crawlersNotFound() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Crawlers": {
                return Optional.ofNullable(clazz.cast(this.crawlers()));
            }
            case "CrawlersNotFound": {
                return Optional.ofNullable(clazz.cast(this.crawlersNotFound()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetCrawlersResponse, T> g) {
        return obj -> g.apply((BatchGetCrawlersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private List<Crawler> crawlers = DefaultSdkAutoConstructList.getInstance();
        private List<String> crawlersNotFound = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetCrawlersResponse model) {
            super(model);
            this.crawlers(model.crawlers);
            this.crawlersNotFound(model.crawlersNotFound);
        }

        public final Collection<Crawler.Builder> getCrawlers() {
            if (this.crawlers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.crawlers != null ? (Collection)this.crawlers.stream().map(Crawler::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder crawlers(Collection<Crawler> crawlers) {
            this.crawlers = CrawlerListCopier.copy(crawlers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder crawlers(Crawler ... crawlers) {
            this.crawlers(Arrays.asList(crawlers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder crawlers(Consumer<Crawler.Builder> ... crawlers) {
            this.crawlers(Stream.of(crawlers).map(c -> (Crawler)((Crawler.Builder)Crawler.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCrawlers(Collection<Crawler.BuilderImpl> crawlers) {
            this.crawlers = CrawlerListCopier.copyFromBuilder(crawlers);
        }

        public final Collection<String> getCrawlersNotFound() {
            if (this.crawlersNotFound instanceof SdkAutoConstructList) {
                return null;
            }
            return this.crawlersNotFound;
        }

        @Override
        public final Builder crawlersNotFound(Collection<String> crawlersNotFound) {
            this.crawlersNotFound = CrawlerNameListCopier.copy(crawlersNotFound);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder crawlersNotFound(String ... crawlersNotFound) {
            this.crawlersNotFound(Arrays.asList(crawlersNotFound));
            return this;
        }

        public final void setCrawlersNotFound(Collection<String> crawlersNotFound) {
            this.crawlersNotFound = CrawlerNameListCopier.copy(crawlersNotFound);
        }

        @Override
        public BatchGetCrawlersResponse build() {
            return new BatchGetCrawlersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetCrawlersResponse> {
        public Builder crawlers(Collection<Crawler> var1);

        public Builder crawlers(Crawler ... var1);

        public Builder crawlers(Consumer<Crawler.Builder> ... var1);

        public Builder crawlersNotFound(Collection<String> var1);

        public Builder crawlersNotFound(String ... var1);
    }
}

