/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.Crawl;
import software.amazon.awssdk.services.glue.model.CrawlListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CrawlerNodeDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CrawlerNodeDetails> {
    private static final SdkField<List<Crawl>> CRAWLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Crawls").getter(CrawlerNodeDetails.getter(CrawlerNodeDetails::crawls)).setter(CrawlerNodeDetails.setter(Builder::crawls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Crawls").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Crawl::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CRAWLS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<Crawl> crawls;

    private CrawlerNodeDetails(BuilderImpl builder) {
        this.crawls = builder.crawls;
    }

    public final boolean hasCrawls() {
        return this.crawls != null && !(this.crawls instanceof SdkAutoConstructList);
    }

    public final List<Crawl> crawls() {
        return this.crawls;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCrawls() ? this.crawls() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CrawlerNodeDetails)) {
            return false;
        }
        CrawlerNodeDetails other = (CrawlerNodeDetails)obj;
        return this.hasCrawls() == other.hasCrawls() && Objects.equals(this.crawls(), other.crawls());
    }

    public final String toString() {
        return ToString.builder((String)"CrawlerNodeDetails").add("Crawls", this.hasCrawls() ? this.crawls() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Crawls": {
                return Optional.ofNullable(clazz.cast(this.crawls()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CrawlerNodeDetails, T> g) {
        return obj -> g.apply((CrawlerNodeDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Crawl> crawls = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CrawlerNodeDetails model) {
            this.crawls(model.crawls);
        }

        public final List<Crawl.Builder> getCrawls() {
            List<Crawl.Builder> result = CrawlListCopier.copyToBuilder(this.crawls);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder crawls(Collection<Crawl> crawls) {
            this.crawls = CrawlListCopier.copy(crawls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder crawls(Crawl ... crawls) {
            this.crawls(Arrays.asList(crawls));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder crawls(Consumer<Crawl.Builder> ... crawls) {
            this.crawls(Stream.of(crawls).map(c -> (Crawl)((Crawl.Builder)Crawl.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCrawls(Collection<Crawl.BuilderImpl> crawls) {
            this.crawls = CrawlListCopier.copyFromBuilder(crawls);
        }

        public CrawlerNodeDetails build() {
            return new CrawlerNodeDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CrawlerNodeDetails> {
        public Builder crawls(Collection<Crawl> var1);

        public Builder crawls(Crawl ... var1);

        public Builder crawls(Consumer<Crawl.Builder> ... var1);
    }
}

