/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.services.glue.model.TriggerNameListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetTriggersRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, BatchGetTriggersRequest> {
    private static final SdkField<List<String>> TRIGGER_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TriggerNames").getter(BatchGetTriggersRequest.getter(BatchGetTriggersRequest::triggerNames)).setter(BatchGetTriggersRequest.setter(Builder::triggerNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TriggerNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRIGGER_NAMES_FIELD));
    private final List<String> triggerNames;

    private BatchGetTriggersRequest(BuilderImpl builder) {
        super(builder);
        this.triggerNames = builder.triggerNames;
    }

    public final boolean hasTriggerNames() {
        return this.triggerNames != null && !(this.triggerNames instanceof SdkAutoConstructList);
    }

    public final List<String> triggerNames() {
        return this.triggerNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTriggerNames() ? this.triggerNames() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetTriggersRequest)) {
            return false;
        }
        BatchGetTriggersRequest other = (BatchGetTriggersRequest)((Object)obj);
        return this.hasTriggerNames() == other.hasTriggerNames() && Objects.equals(this.triggerNames(), other.triggerNames());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetTriggersRequest").add("TriggerNames", this.hasTriggerNames() ? this.triggerNames() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TriggerNames": {
                return Optional.ofNullable(clazz.cast(this.triggerNames()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetTriggersRequest, T> g) {
        return obj -> g.apply((BatchGetTriggersRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private List<String> triggerNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetTriggersRequest model) {
            super(model);
            this.triggerNames(model.triggerNames);
        }

        public final Collection<String> getTriggerNames() {
            if (this.triggerNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.triggerNames;
        }

        @Override
        public final Builder triggerNames(Collection<String> triggerNames) {
            this.triggerNames = TriggerNameListCopier.copy(triggerNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggerNames(String ... triggerNames) {
            this.triggerNames(Arrays.asList(triggerNames));
            return this;
        }

        public final void setTriggerNames(Collection<String> triggerNames) {
            this.triggerNames = TriggerNameListCopier.copy(triggerNames);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetTriggersRequest build() {
            return new BatchGetTriggersRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetTriggersRequest> {
        public Builder triggerNames(Collection<String> var1);

        public Builder triggerNames(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

