/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.services.glue.model.Table;
import software.amazon.awssdk.services.glue.model.TableListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTablesResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, GetTablesResponse> {
    private static final SdkField<List<Table>> TABLE_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TableList").getter(GetTablesResponse.getter(GetTablesResponse::tableList)).setter(GetTablesResponse.setter(Builder::tableList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Table::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetTablesResponse.getter(GetTablesResponse::nextToken)).setter(GetTablesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<Table> tableList;
    private final String nextToken;

    private GetTablesResponse(BuilderImpl builder) {
        super(builder);
        this.tableList = builder.tableList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasTableList() {
        return this.tableList != null && !(this.tableList instanceof SdkAutoConstructList);
    }

    public final List<Table> tableList() {
        return this.tableList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTableList() ? this.tableList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTablesResponse)) {
            return false;
        }
        GetTablesResponse other = (GetTablesResponse)((Object)obj);
        return this.hasTableList() == other.hasTableList() && Objects.equals(this.tableList(), other.tableList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetTablesResponse").add("TableList", this.hasTableList() ? this.tableList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TableList": {
                return Optional.ofNullable(clazz.cast(this.tableList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTablesResponse, T> g) {
        return obj -> g.apply((GetTablesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private List<Table> tableList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTablesResponse model) {
            super(model);
            this.tableList(model.tableList);
            this.nextToken(model.nextToken);
        }

        public final Collection<Table.Builder> getTableList() {
            if (this.tableList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tableList != null ? (Collection)this.tableList.stream().map(Table::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tableList(Collection<Table> tableList) {
            this.tableList = TableListCopier.copy(tableList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tableList(Table ... tableList) {
            this.tableList(Arrays.asList(tableList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tableList(Consumer<Table.Builder> ... tableList) {
            this.tableList(Stream.of(tableList).map(c -> (Table)((Table.Builder)Table.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTableList(Collection<Table.BuilderImpl> tableList) {
            this.tableList = TableListCopier.copyFromBuilder(tableList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetTablesResponse build() {
            return new GetTablesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTablesResponse> {
        public Builder tableList(Collection<Table> var1);

        public Builder tableList(Table ... var1);

        public Builder tableList(Consumer<Table.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

