/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.TaskRunProperties;
import software.amazon.awssdk.services.glue.model.TaskStatusType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TaskRun
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TaskRun> {
    private static final SdkField<String> TRANSFORM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransformId").getter(TaskRun.getter(TaskRun::transformId)).setter(TaskRun.setter(Builder::transformId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformId").build()}).build();
    private static final SdkField<String> TASK_RUN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TaskRunId").getter(TaskRun.getter(TaskRun::taskRunId)).setter(TaskRun.setter(Builder::taskRunId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskRunId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(TaskRun.getter(TaskRun::statusAsString)).setter(TaskRun.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> LOG_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogGroupName").getter(TaskRun.getter(TaskRun::logGroupName)).setter(TaskRun.setter(Builder::logGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogGroupName").build()}).build();
    private static final SdkField<TaskRunProperties> PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Properties").getter(TaskRun.getter(TaskRun::properties)).setter(TaskRun.setter(Builder::properties)).constructor(TaskRunProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Properties").build()}).build();
    private static final SdkField<String> ERROR_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorString").getter(TaskRun.getter(TaskRun::errorString)).setter(TaskRun.setter(Builder::errorString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorString").build()}).build();
    private static final SdkField<Instant> STARTED_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartedOn").getter(TaskRun.getter(TaskRun::startedOn)).setter(TaskRun.setter(Builder::startedOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartedOn").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedOn").getter(TaskRun.getter(TaskRun::lastModifiedOn)).setter(TaskRun.setter(Builder::lastModifiedOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedOn").build()}).build();
    private static final SdkField<Instant> COMPLETED_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CompletedOn").getter(TaskRun.getter(TaskRun::completedOn)).setter(TaskRun.setter(Builder::completedOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletedOn").build()}).build();
    private static final SdkField<Integer> EXECUTION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ExecutionTime").getter(TaskRun.getter(TaskRun::executionTime)).setter(TaskRun.setter(Builder::executionTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSFORM_ID_FIELD, TASK_RUN_ID_FIELD, STATUS_FIELD, LOG_GROUP_NAME_FIELD, PROPERTIES_FIELD, ERROR_STRING_FIELD, STARTED_ON_FIELD, LAST_MODIFIED_ON_FIELD, COMPLETED_ON_FIELD, EXECUTION_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String transformId;
    private final String taskRunId;
    private final String status;
    private final String logGroupName;
    private final TaskRunProperties properties;
    private final String errorString;
    private final Instant startedOn;
    private final Instant lastModifiedOn;
    private final Instant completedOn;
    private final Integer executionTime;

    private TaskRun(BuilderImpl builder) {
        this.transformId = builder.transformId;
        this.taskRunId = builder.taskRunId;
        this.status = builder.status;
        this.logGroupName = builder.logGroupName;
        this.properties = builder.properties;
        this.errorString = builder.errorString;
        this.startedOn = builder.startedOn;
        this.lastModifiedOn = builder.lastModifiedOn;
        this.completedOn = builder.completedOn;
        this.executionTime = builder.executionTime;
    }

    public final String transformId() {
        return this.transformId;
    }

    public final String taskRunId() {
        return this.taskRunId;
    }

    public final TaskStatusType status() {
        return TaskStatusType.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String logGroupName() {
        return this.logGroupName;
    }

    public final TaskRunProperties properties() {
        return this.properties;
    }

    public final String errorString() {
        return this.errorString;
    }

    public final Instant startedOn() {
        return this.startedOn;
    }

    public final Instant lastModifiedOn() {
        return this.lastModifiedOn;
    }

    public final Instant completedOn() {
        return this.completedOn;
    }

    public final Integer executionTime() {
        return this.executionTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.transformId());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskRunId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.logGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.properties());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.completedOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskRun)) {
            return false;
        }
        TaskRun other = (TaskRun)obj;
        return Objects.equals(this.transformId(), other.transformId()) && Objects.equals(this.taskRunId(), other.taskRunId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.logGroupName(), other.logGroupName()) && Objects.equals(this.properties(), other.properties()) && Objects.equals(this.errorString(), other.errorString()) && Objects.equals(this.startedOn(), other.startedOn()) && Objects.equals(this.lastModifiedOn(), other.lastModifiedOn()) && Objects.equals(this.completedOn(), other.completedOn()) && Objects.equals(this.executionTime(), other.executionTime());
    }

    public final String toString() {
        return ToString.builder((String)"TaskRun").add("TransformId", (Object)this.transformId()).add("TaskRunId", (Object)this.taskRunId()).add("Status", (Object)this.statusAsString()).add("LogGroupName", (Object)this.logGroupName()).add("Properties", (Object)this.properties()).add("ErrorString", (Object)this.errorString()).add("StartedOn", (Object)this.startedOn()).add("LastModifiedOn", (Object)this.lastModifiedOn()).add("CompletedOn", (Object)this.completedOn()).add("ExecutionTime", (Object)this.executionTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TransformId": {
                return Optional.ofNullable(clazz.cast(this.transformId()));
            }
            case "TaskRunId": {
                return Optional.ofNullable(clazz.cast(this.taskRunId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "LogGroupName": {
                return Optional.ofNullable(clazz.cast(this.logGroupName()));
            }
            case "Properties": {
                return Optional.ofNullable(clazz.cast(this.properties()));
            }
            case "ErrorString": {
                return Optional.ofNullable(clazz.cast(this.errorString()));
            }
            case "StartedOn": {
                return Optional.ofNullable(clazz.cast(this.startedOn()));
            }
            case "LastModifiedOn": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedOn()));
            }
            case "CompletedOn": {
                return Optional.ofNullable(clazz.cast(this.completedOn()));
            }
            case "ExecutionTime": {
                return Optional.ofNullable(clazz.cast(this.executionTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TaskRun, T> g) {
        return obj -> g.apply((TaskRun)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String transformId;
        private String taskRunId;
        private String status;
        private String logGroupName;
        private TaskRunProperties properties;
        private String errorString;
        private Instant startedOn;
        private Instant lastModifiedOn;
        private Instant completedOn;
        private Integer executionTime;

        private BuilderImpl() {
        }

        private BuilderImpl(TaskRun model) {
            this.transformId(model.transformId);
            this.taskRunId(model.taskRunId);
            this.status(model.status);
            this.logGroupName(model.logGroupName);
            this.properties(model.properties);
            this.errorString(model.errorString);
            this.startedOn(model.startedOn);
            this.lastModifiedOn(model.lastModifiedOn);
            this.completedOn(model.completedOn);
            this.executionTime(model.executionTime);
        }

        public final String getTransformId() {
            return this.transformId;
        }

        @Override
        public final Builder transformId(String transformId) {
            this.transformId = transformId;
            return this;
        }

        public final void setTransformId(String transformId) {
            this.transformId = transformId;
        }

        public final String getTaskRunId() {
            return this.taskRunId;
        }

        @Override
        public final Builder taskRunId(String taskRunId) {
            this.taskRunId = taskRunId;
            return this;
        }

        public final void setTaskRunId(String taskRunId) {
            this.taskRunId = taskRunId;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TaskStatusType status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getLogGroupName() {
            return this.logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        public final TaskRunProperties.Builder getProperties() {
            return this.properties != null ? this.properties.toBuilder() : null;
        }

        @Override
        public final Builder properties(TaskRunProperties properties) {
            this.properties = properties;
            return this;
        }

        public final void setProperties(TaskRunProperties.BuilderImpl properties) {
            this.properties = properties != null ? properties.build() : null;
        }

        public final String getErrorString() {
            return this.errorString;
        }

        @Override
        public final Builder errorString(String errorString) {
            this.errorString = errorString;
            return this;
        }

        public final void setErrorString(String errorString) {
            this.errorString = errorString;
        }

        public final Instant getStartedOn() {
            return this.startedOn;
        }

        @Override
        public final Builder startedOn(Instant startedOn) {
            this.startedOn = startedOn;
            return this;
        }

        public final void setStartedOn(Instant startedOn) {
            this.startedOn = startedOn;
        }

        public final Instant getLastModifiedOn() {
            return this.lastModifiedOn;
        }

        @Override
        public final Builder lastModifiedOn(Instant lastModifiedOn) {
            this.lastModifiedOn = lastModifiedOn;
            return this;
        }

        public final void setLastModifiedOn(Instant lastModifiedOn) {
            this.lastModifiedOn = lastModifiedOn;
        }

        public final Instant getCompletedOn() {
            return this.completedOn;
        }

        @Override
        public final Builder completedOn(Instant completedOn) {
            this.completedOn = completedOn;
            return this;
        }

        public final void setCompletedOn(Instant completedOn) {
            this.completedOn = completedOn;
        }

        public final Integer getExecutionTime() {
            return this.executionTime;
        }

        @Override
        public final Builder executionTime(Integer executionTime) {
            this.executionTime = executionTime;
            return this;
        }

        public final void setExecutionTime(Integer executionTime) {
            this.executionTime = executionTime;
        }

        public TaskRun build() {
            return new TaskRun(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TaskRun> {
        public Builder transformId(String var1);

        public Builder taskRunId(String var1);

        public Builder status(String var1);

        public Builder status(TaskStatusType var1);

        public Builder logGroupName(String var1);

        public Builder properties(TaskRunProperties var1);

        default public Builder properties(Consumer<TaskRunProperties.Builder> properties) {
            return this.properties((TaskRunProperties)((TaskRunProperties.Builder)TaskRunProperties.builder().applyMutation(properties)).build());
        }

        public Builder errorString(String var1);

        public Builder startedOn(Instant var1);

        public Builder lastModifiedOn(Instant var1);

        public Builder completedOn(Instant var1);

        public Builder executionTime(Integer var1);
    }
}

