/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.EnableHybridValues;
import software.amazon.awssdk.services.glue.model.ExistCondition;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutResourcePolicyRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, PutResourcePolicyRequest> {
    private static final SdkField<String> POLICY_IN_JSON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyInJson").getter(PutResourcePolicyRequest.getter(PutResourcePolicyRequest::policyInJson)).setter(PutResourcePolicyRequest.setter(Builder::policyInJson)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyInJson").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(PutResourcePolicyRequest.getter(PutResourcePolicyRequest::resourceArn)).setter(PutResourcePolicyRequest.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final SdkField<String> POLICY_HASH_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyHashCondition").getter(PutResourcePolicyRequest.getter(PutResourcePolicyRequest::policyHashCondition)).setter(PutResourcePolicyRequest.setter(Builder::policyHashCondition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyHashCondition").build()}).build();
    private static final SdkField<String> POLICY_EXISTS_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyExistsCondition").getter(PutResourcePolicyRequest.getter(PutResourcePolicyRequest::policyExistsConditionAsString)).setter(PutResourcePolicyRequest.setter(Builder::policyExistsCondition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyExistsCondition").build()}).build();
    private static final SdkField<String> ENABLE_HYBRID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EnableHybrid").getter(PutResourcePolicyRequest.getter(PutResourcePolicyRequest::enableHybridAsString)).setter(PutResourcePolicyRequest.setter(Builder::enableHybrid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableHybrid").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_IN_JSON_FIELD, RESOURCE_ARN_FIELD, POLICY_HASH_CONDITION_FIELD, POLICY_EXISTS_CONDITION_FIELD, ENABLE_HYBRID_FIELD));
    private final String policyInJson;
    private final String resourceArn;
    private final String policyHashCondition;
    private final String policyExistsCondition;
    private final String enableHybrid;

    private PutResourcePolicyRequest(BuilderImpl builder) {
        super(builder);
        this.policyInJson = builder.policyInJson;
        this.resourceArn = builder.resourceArn;
        this.policyHashCondition = builder.policyHashCondition;
        this.policyExistsCondition = builder.policyExistsCondition;
        this.enableHybrid = builder.enableHybrid;
    }

    public final String policyInJson() {
        return this.policyInJson;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final String policyHashCondition() {
        return this.policyHashCondition;
    }

    public final ExistCondition policyExistsCondition() {
        return ExistCondition.fromValue(this.policyExistsCondition);
    }

    public final String policyExistsConditionAsString() {
        return this.policyExistsCondition;
    }

    public final EnableHybridValues enableHybrid() {
        return EnableHybridValues.fromValue(this.enableHybrid);
    }

    public final String enableHybridAsString() {
        return this.enableHybrid;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.policyInJson());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyHashCondition());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyExistsConditionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableHybridAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutResourcePolicyRequest)) {
            return false;
        }
        PutResourcePolicyRequest other = (PutResourcePolicyRequest)((Object)obj);
        return Objects.equals(this.policyInJson(), other.policyInJson()) && Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.policyHashCondition(), other.policyHashCondition()) && Objects.equals(this.policyExistsConditionAsString(), other.policyExistsConditionAsString()) && Objects.equals(this.enableHybridAsString(), other.enableHybridAsString());
    }

    public final String toString() {
        return ToString.builder((String)"PutResourcePolicyRequest").add("PolicyInJson", (Object)this.policyInJson()).add("ResourceArn", (Object)this.resourceArn()).add("PolicyHashCondition", (Object)this.policyHashCondition()).add("PolicyExistsCondition", (Object)this.policyExistsConditionAsString()).add("EnableHybrid", (Object)this.enableHybridAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicyInJson": {
                return Optional.ofNullable(clazz.cast(this.policyInJson()));
            }
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "PolicyHashCondition": {
                return Optional.ofNullable(clazz.cast(this.policyHashCondition()));
            }
            case "PolicyExistsCondition": {
                return Optional.ofNullable(clazz.cast(this.policyExistsConditionAsString()));
            }
            case "EnableHybrid": {
                return Optional.ofNullable(clazz.cast(this.enableHybridAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutResourcePolicyRequest, T> g) {
        return obj -> g.apply((PutResourcePolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String policyInJson;
        private String resourceArn;
        private String policyHashCondition;
        private String policyExistsCondition;
        private String enableHybrid;

        private BuilderImpl() {
        }

        private BuilderImpl(PutResourcePolicyRequest model) {
            super(model);
            this.policyInJson(model.policyInJson);
            this.resourceArn(model.resourceArn);
            this.policyHashCondition(model.policyHashCondition);
            this.policyExistsCondition(model.policyExistsCondition);
            this.enableHybrid(model.enableHybrid);
        }

        public final String getPolicyInJson() {
            return this.policyInJson;
        }

        @Override
        public final Builder policyInJson(String policyInJson) {
            this.policyInJson = policyInJson;
            return this;
        }

        public final void setPolicyInJson(String policyInJson) {
            this.policyInJson = policyInJson;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        public final String getPolicyHashCondition() {
            return this.policyHashCondition;
        }

        @Override
        public final Builder policyHashCondition(String policyHashCondition) {
            this.policyHashCondition = policyHashCondition;
            return this;
        }

        public final void setPolicyHashCondition(String policyHashCondition) {
            this.policyHashCondition = policyHashCondition;
        }

        public final String getPolicyExistsCondition() {
            return this.policyExistsCondition;
        }

        @Override
        public final Builder policyExistsCondition(String policyExistsCondition) {
            this.policyExistsCondition = policyExistsCondition;
            return this;
        }

        @Override
        public final Builder policyExistsCondition(ExistCondition policyExistsCondition) {
            this.policyExistsCondition(policyExistsCondition == null ? null : policyExistsCondition.toString());
            return this;
        }

        public final void setPolicyExistsCondition(String policyExistsCondition) {
            this.policyExistsCondition = policyExistsCondition;
        }

        public final String getEnableHybrid() {
            return this.enableHybrid;
        }

        @Override
        public final Builder enableHybrid(String enableHybrid) {
            this.enableHybrid = enableHybrid;
            return this;
        }

        @Override
        public final Builder enableHybrid(EnableHybridValues enableHybrid) {
            this.enableHybrid(enableHybrid == null ? null : enableHybrid.toString());
            return this;
        }

        public final void setEnableHybrid(String enableHybrid) {
            this.enableHybrid = enableHybrid;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutResourcePolicyRequest build() {
            return new PutResourcePolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutResourcePolicyRequest> {
        public Builder policyInJson(String var1);

        public Builder resourceArn(String var1);

        public Builder policyHashCondition(String var1);

        public Builder policyExistsCondition(String var1);

        public Builder policyExistsCondition(ExistCondition var1);

        public Builder enableHybrid(String var1);

        public Builder enableHybrid(EnableHybridValues var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

