/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.CrawlState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Crawl
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Crawl> {
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(Crawl.getter(Crawl::stateAsString)).setter(Crawl.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<Instant> STARTED_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartedOn").getter(Crawl.getter(Crawl::startedOn)).setter(Crawl.setter(Builder::startedOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartedOn").build()}).build();
    private static final SdkField<Instant> COMPLETED_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CompletedOn").getter(Crawl.getter(Crawl::completedOn)).setter(Crawl.setter(Builder::completedOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletedOn").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorMessage").getter(Crawl.getter(Crawl::errorMessage)).setter(Crawl.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()}).build();
    private static final SdkField<String> LOG_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogGroup").getter(Crawl.getter(Crawl::logGroup)).setter(Crawl.setter(Builder::logGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogGroup").build()}).build();
    private static final SdkField<String> LOG_STREAM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogStream").getter(Crawl.getter(Crawl::logStream)).setter(Crawl.setter(Builder::logStream)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogStream").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_FIELD, STARTED_ON_FIELD, COMPLETED_ON_FIELD, ERROR_MESSAGE_FIELD, LOG_GROUP_FIELD, LOG_STREAM_FIELD));
    private static final long serialVersionUID = 1L;
    private final String state;
    private final Instant startedOn;
    private final Instant completedOn;
    private final String errorMessage;
    private final String logGroup;
    private final String logStream;

    private Crawl(BuilderImpl builder) {
        this.state = builder.state;
        this.startedOn = builder.startedOn;
        this.completedOn = builder.completedOn;
        this.errorMessage = builder.errorMessage;
        this.logGroup = builder.logGroup;
        this.logStream = builder.logStream;
    }

    public final CrawlState state() {
        return CrawlState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final Instant startedOn() {
        return this.startedOn;
    }

    public final Instant completedOn() {
        return this.completedOn;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public final String logGroup() {
        return this.logGroup;
    }

    public final String logStream() {
        return this.logStream;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.completedOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.logGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.logStream());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Crawl)) {
            return false;
        }
        Crawl other = (Crawl)obj;
        return Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.startedOn(), other.startedOn()) && Objects.equals(this.completedOn(), other.completedOn()) && Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.logGroup(), other.logGroup()) && Objects.equals(this.logStream(), other.logStream());
    }

    public final String toString() {
        return ToString.builder((String)"Crawl").add("State", (Object)this.stateAsString()).add("StartedOn", (Object)this.startedOn()).add("CompletedOn", (Object)this.completedOn()).add("ErrorMessage", (Object)this.errorMessage()).add("LogGroup", (Object)this.logGroup()).add("LogStream", (Object)this.logStream()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "StartedOn": {
                return Optional.ofNullable(clazz.cast(this.startedOn()));
            }
            case "CompletedOn": {
                return Optional.ofNullable(clazz.cast(this.completedOn()));
            }
            case "ErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "LogGroup": {
                return Optional.ofNullable(clazz.cast(this.logGroup()));
            }
            case "LogStream": {
                return Optional.ofNullable(clazz.cast(this.logStream()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Crawl, T> g) {
        return obj -> g.apply((Crawl)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String state;
        private Instant startedOn;
        private Instant completedOn;
        private String errorMessage;
        private String logGroup;
        private String logStream;

        private BuilderImpl() {
        }

        private BuilderImpl(Crawl model) {
            this.state(model.state);
            this.startedOn(model.startedOn);
            this.completedOn(model.completedOn);
            this.errorMessage(model.errorMessage);
            this.logGroup(model.logGroup);
            this.logStream(model.logStream);
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(CrawlState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Instant getStartedOn() {
            return this.startedOn;
        }

        @Override
        public final Builder startedOn(Instant startedOn) {
            this.startedOn = startedOn;
            return this;
        }

        public final void setStartedOn(Instant startedOn) {
            this.startedOn = startedOn;
        }

        public final Instant getCompletedOn() {
            return this.completedOn;
        }

        @Override
        public final Builder completedOn(Instant completedOn) {
            this.completedOn = completedOn;
            return this;
        }

        public final void setCompletedOn(Instant completedOn) {
            this.completedOn = completedOn;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public final String getLogGroup() {
            return this.logGroup;
        }

        @Override
        public final Builder logGroup(String logGroup) {
            this.logGroup = logGroup;
            return this;
        }

        public final void setLogGroup(String logGroup) {
            this.logGroup = logGroup;
        }

        public final String getLogStream() {
            return this.logStream;
        }

        @Override
        public final Builder logStream(String logStream) {
            this.logStream = logStream;
            return this;
        }

        public final void setLogStream(String logStream) {
            this.logStream = logStream;
        }

        public Crawl build() {
            return new Crawl(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Crawl> {
        public Builder state(String var1);

        public Builder state(CrawlState var1);

        public Builder startedOn(Instant var1);

        public Builder completedOn(Instant var1);

        public Builder errorMessage(String var1);

        public Builder logGroup(String var1);

        public Builder logStream(String var1);
    }
}

