/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.glue.model.DevEndpointCustomLibraries;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.services.glue.model.MapValueCopier;
import software.amazon.awssdk.services.glue.model.PublicKeysListCopier;
import software.amazon.awssdk.services.glue.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDevEndpointRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, UpdateDevEndpointRequest> {
    private static final SdkField<String> ENDPOINT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointName").getter(UpdateDevEndpointRequest.getter(UpdateDevEndpointRequest::endpointName)).setter(UpdateDevEndpointRequest.setter(Builder::endpointName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointName").build()}).build();
    private static final SdkField<String> PUBLIC_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublicKey").getter(UpdateDevEndpointRequest.getter(UpdateDevEndpointRequest::publicKey)).setter(UpdateDevEndpointRequest.setter(Builder::publicKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicKey").build()}).build();
    private static final SdkField<List<String>> ADD_PUBLIC_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AddPublicKeys").getter(UpdateDevEndpointRequest.getter(UpdateDevEndpointRequest::addPublicKeys)).setter(UpdateDevEndpointRequest.setter(Builder::addPublicKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddPublicKeys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> DELETE_PUBLIC_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DeletePublicKeys").getter(UpdateDevEndpointRequest.getter(UpdateDevEndpointRequest::deletePublicKeys)).setter(UpdateDevEndpointRequest.setter(Builder::deletePublicKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletePublicKeys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<DevEndpointCustomLibraries> CUSTOM_LIBRARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CustomLibraries").getter(UpdateDevEndpointRequest.getter(UpdateDevEndpointRequest::customLibraries)).setter(UpdateDevEndpointRequest.setter(Builder::customLibraries)).constructor(DevEndpointCustomLibraries::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomLibraries").build()}).build();
    private static final SdkField<Boolean> UPDATE_ETL_LIBRARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("UpdateEtlLibraries").getter(UpdateDevEndpointRequest.getter(UpdateDevEndpointRequest::updateEtlLibraries)).setter(UpdateDevEndpointRequest.setter(Builder::updateEtlLibraries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateEtlLibraries").build()}).build();
    private static final SdkField<List<String>> DELETE_ARGUMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DeleteArguments").getter(UpdateDevEndpointRequest.getter(UpdateDevEndpointRequest::deleteArguments)).setter(UpdateDevEndpointRequest.setter(Builder::deleteArguments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteArguments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> ADD_ARGUMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("AddArguments").getter(UpdateDevEndpointRequest.getter(UpdateDevEndpointRequest::addArguments)).setter(UpdateDevEndpointRequest.setter(Builder::addArguments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddArguments").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_NAME_FIELD, PUBLIC_KEY_FIELD, ADD_PUBLIC_KEYS_FIELD, DELETE_PUBLIC_KEYS_FIELD, CUSTOM_LIBRARIES_FIELD, UPDATE_ETL_LIBRARIES_FIELD, DELETE_ARGUMENTS_FIELD, ADD_ARGUMENTS_FIELD));
    private final String endpointName;
    private final String publicKey;
    private final List<String> addPublicKeys;
    private final List<String> deletePublicKeys;
    private final DevEndpointCustomLibraries customLibraries;
    private final Boolean updateEtlLibraries;
    private final List<String> deleteArguments;
    private final Map<String, String> addArguments;

    private UpdateDevEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.endpointName = builder.endpointName;
        this.publicKey = builder.publicKey;
        this.addPublicKeys = builder.addPublicKeys;
        this.deletePublicKeys = builder.deletePublicKeys;
        this.customLibraries = builder.customLibraries;
        this.updateEtlLibraries = builder.updateEtlLibraries;
        this.deleteArguments = builder.deleteArguments;
        this.addArguments = builder.addArguments;
    }

    public final String endpointName() {
        return this.endpointName;
    }

    public final String publicKey() {
        return this.publicKey;
    }

    public final boolean hasAddPublicKeys() {
        return this.addPublicKeys != null && !(this.addPublicKeys instanceof SdkAutoConstructList);
    }

    public final List<String> addPublicKeys() {
        return this.addPublicKeys;
    }

    public final boolean hasDeletePublicKeys() {
        return this.deletePublicKeys != null && !(this.deletePublicKeys instanceof SdkAutoConstructList);
    }

    public final List<String> deletePublicKeys() {
        return this.deletePublicKeys;
    }

    public final DevEndpointCustomLibraries customLibraries() {
        return this.customLibraries;
    }

    public final Boolean updateEtlLibraries() {
        return this.updateEtlLibraries;
    }

    public final boolean hasDeleteArguments() {
        return this.deleteArguments != null && !(this.deleteArguments instanceof SdkAutoConstructList);
    }

    public final List<String> deleteArguments() {
        return this.deleteArguments;
    }

    public final boolean hasAddArguments() {
        return this.addArguments != null && !(this.addArguments instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> addArguments() {
        return this.addArguments;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointName());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAddPublicKeys() ? this.addPublicKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDeletePublicKeys() ? this.deletePublicKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.customLibraries());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateEtlLibraries());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDeleteArguments() ? this.deleteArguments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAddArguments() ? this.addArguments() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDevEndpointRequest)) {
            return false;
        }
        UpdateDevEndpointRequest other = (UpdateDevEndpointRequest)((Object)obj);
        return Objects.equals(this.endpointName(), other.endpointName()) && Objects.equals(this.publicKey(), other.publicKey()) && this.hasAddPublicKeys() == other.hasAddPublicKeys() && Objects.equals(this.addPublicKeys(), other.addPublicKeys()) && this.hasDeletePublicKeys() == other.hasDeletePublicKeys() && Objects.equals(this.deletePublicKeys(), other.deletePublicKeys()) && Objects.equals(this.customLibraries(), other.customLibraries()) && Objects.equals(this.updateEtlLibraries(), other.updateEtlLibraries()) && this.hasDeleteArguments() == other.hasDeleteArguments() && Objects.equals(this.deleteArguments(), other.deleteArguments()) && this.hasAddArguments() == other.hasAddArguments() && Objects.equals(this.addArguments(), other.addArguments());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateDevEndpointRequest").add("EndpointName", (Object)this.endpointName()).add("PublicKey", (Object)this.publicKey()).add("AddPublicKeys", this.hasAddPublicKeys() ? this.addPublicKeys() : null).add("DeletePublicKeys", this.hasDeletePublicKeys() ? this.deletePublicKeys() : null).add("CustomLibraries", (Object)this.customLibraries()).add("UpdateEtlLibraries", (Object)this.updateEtlLibraries()).add("DeleteArguments", this.hasDeleteArguments() ? this.deleteArguments() : null).add("AddArguments", this.hasAddArguments() ? this.addArguments() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EndpointName": {
                return Optional.ofNullable(clazz.cast(this.endpointName()));
            }
            case "PublicKey": {
                return Optional.ofNullable(clazz.cast(this.publicKey()));
            }
            case "AddPublicKeys": {
                return Optional.ofNullable(clazz.cast(this.addPublicKeys()));
            }
            case "DeletePublicKeys": {
                return Optional.ofNullable(clazz.cast(this.deletePublicKeys()));
            }
            case "CustomLibraries": {
                return Optional.ofNullable(clazz.cast(this.customLibraries()));
            }
            case "UpdateEtlLibraries": {
                return Optional.ofNullable(clazz.cast(this.updateEtlLibraries()));
            }
            case "DeleteArguments": {
                return Optional.ofNullable(clazz.cast(this.deleteArguments()));
            }
            case "AddArguments": {
                return Optional.ofNullable(clazz.cast(this.addArguments()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDevEndpointRequest, T> g) {
        return obj -> g.apply((UpdateDevEndpointRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String endpointName;
        private String publicKey;
        private List<String> addPublicKeys = DefaultSdkAutoConstructList.getInstance();
        private List<String> deletePublicKeys = DefaultSdkAutoConstructList.getInstance();
        private DevEndpointCustomLibraries customLibraries;
        private Boolean updateEtlLibraries;
        private List<String> deleteArguments = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> addArguments = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDevEndpointRequest model) {
            super(model);
            this.endpointName(model.endpointName);
            this.publicKey(model.publicKey);
            this.addPublicKeys(model.addPublicKeys);
            this.deletePublicKeys(model.deletePublicKeys);
            this.customLibraries(model.customLibraries);
            this.updateEtlLibraries(model.updateEtlLibraries);
            this.deleteArguments(model.deleteArguments);
            this.addArguments(model.addArguments);
        }

        public final String getEndpointName() {
            return this.endpointName;
        }

        @Override
        public final Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        public final void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        public final String getPublicKey() {
            return this.publicKey;
        }

        @Override
        public final Builder publicKey(String publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        public final void setPublicKey(String publicKey) {
            this.publicKey = publicKey;
        }

        public final Collection<String> getAddPublicKeys() {
            if (this.addPublicKeys instanceof SdkAutoConstructList) {
                return null;
            }
            return this.addPublicKeys;
        }

        @Override
        public final Builder addPublicKeys(Collection<String> addPublicKeys) {
            this.addPublicKeys = PublicKeysListCopier.copy(addPublicKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addPublicKeys(String ... addPublicKeys) {
            this.addPublicKeys(Arrays.asList(addPublicKeys));
            return this;
        }

        public final void setAddPublicKeys(Collection<String> addPublicKeys) {
            this.addPublicKeys = PublicKeysListCopier.copy(addPublicKeys);
        }

        public final Collection<String> getDeletePublicKeys() {
            if (this.deletePublicKeys instanceof SdkAutoConstructList) {
                return null;
            }
            return this.deletePublicKeys;
        }

        @Override
        public final Builder deletePublicKeys(Collection<String> deletePublicKeys) {
            this.deletePublicKeys = PublicKeysListCopier.copy(deletePublicKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deletePublicKeys(String ... deletePublicKeys) {
            this.deletePublicKeys(Arrays.asList(deletePublicKeys));
            return this;
        }

        public final void setDeletePublicKeys(Collection<String> deletePublicKeys) {
            this.deletePublicKeys = PublicKeysListCopier.copy(deletePublicKeys);
        }

        public final DevEndpointCustomLibraries.Builder getCustomLibraries() {
            return this.customLibraries != null ? this.customLibraries.toBuilder() : null;
        }

        @Override
        public final Builder customLibraries(DevEndpointCustomLibraries customLibraries) {
            this.customLibraries = customLibraries;
            return this;
        }

        public final void setCustomLibraries(DevEndpointCustomLibraries.BuilderImpl customLibraries) {
            this.customLibraries = customLibraries != null ? customLibraries.build() : null;
        }

        public final Boolean getUpdateEtlLibraries() {
            return this.updateEtlLibraries;
        }

        @Override
        public final Builder updateEtlLibraries(Boolean updateEtlLibraries) {
            this.updateEtlLibraries = updateEtlLibraries;
            return this;
        }

        public final void setUpdateEtlLibraries(Boolean updateEtlLibraries) {
            this.updateEtlLibraries = updateEtlLibraries;
        }

        public final Collection<String> getDeleteArguments() {
            if (this.deleteArguments instanceof SdkAutoConstructList) {
                return null;
            }
            return this.deleteArguments;
        }

        @Override
        public final Builder deleteArguments(Collection<String> deleteArguments) {
            this.deleteArguments = StringListCopier.copy(deleteArguments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deleteArguments(String ... deleteArguments) {
            this.deleteArguments(Arrays.asList(deleteArguments));
            return this;
        }

        public final void setDeleteArguments(Collection<String> deleteArguments) {
            this.deleteArguments = StringListCopier.copy(deleteArguments);
        }

        public final Map<String, String> getAddArguments() {
            if (this.addArguments instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.addArguments;
        }

        @Override
        public final Builder addArguments(Map<String, String> addArguments) {
            this.addArguments = MapValueCopier.copy(addArguments);
            return this;
        }

        public final void setAddArguments(Map<String, String> addArguments) {
            this.addArguments = MapValueCopier.copy(addArguments);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDevEndpointRequest build() {
            return new UpdateDevEndpointRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDevEndpointRequest> {
        public Builder endpointName(String var1);

        public Builder publicKey(String var1);

        public Builder addPublicKeys(Collection<String> var1);

        public Builder addPublicKeys(String ... var1);

        public Builder deletePublicKeys(Collection<String> var1);

        public Builder deletePublicKeys(String ... var1);

        public Builder customLibraries(DevEndpointCustomLibraries var1);

        default public Builder customLibraries(Consumer<DevEndpointCustomLibraries.Builder> customLibraries) {
            return this.customLibraries((DevEndpointCustomLibraries)((DevEndpointCustomLibraries.Builder)DevEndpointCustomLibraries.builder().applyMutation(customLibraries)).build());
        }

        public Builder updateEtlLibraries(Boolean var1);

        public Builder deleteArguments(Collection<String> var1);

        public Builder deleteArguments(String ... var1);

        public Builder addArguments(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

