/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.GetResourcePoliciesResponseListCopier;
import software.amazon.awssdk.services.glue.model.GluePolicy;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetResourcePoliciesResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, GetResourcePoliciesResponse> {
    private static final SdkField<List<GluePolicy>> GET_RESOURCE_POLICIES_RESPONSE_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GetResourcePoliciesResponseList").getter(GetResourcePoliciesResponse.getter(GetResourcePoliciesResponse::getResourcePoliciesResponseList)).setter(GetResourcePoliciesResponse.setter(Builder::getResourcePoliciesResponseList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GetResourcePoliciesResponseList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GluePolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetResourcePoliciesResponse.getter(GetResourcePoliciesResponse::nextToken)).setter(GetResourcePoliciesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GET_RESOURCE_POLICIES_RESPONSE_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<GluePolicy> getResourcePoliciesResponseList;
    private final String nextToken;

    private GetResourcePoliciesResponse(BuilderImpl builder) {
        super(builder);
        this.getResourcePoliciesResponseList = builder.getResourcePoliciesResponseList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasGetResourcePoliciesResponseList() {
        return this.getResourcePoliciesResponseList != null && !(this.getResourcePoliciesResponseList instanceof SdkAutoConstructList);
    }

    public final List<GluePolicy> getResourcePoliciesResponseList() {
        return this.getResourcePoliciesResponseList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGetResourcePoliciesResponseList() ? this.getResourcePoliciesResponseList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourcePoliciesResponse)) {
            return false;
        }
        GetResourcePoliciesResponse other = (GetResourcePoliciesResponse)((Object)obj);
        return this.hasGetResourcePoliciesResponseList() == other.hasGetResourcePoliciesResponseList() && Objects.equals(this.getResourcePoliciesResponseList(), other.getResourcePoliciesResponseList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetResourcePoliciesResponse").add("GetResourcePoliciesResponseList", this.hasGetResourcePoliciesResponseList() ? this.getResourcePoliciesResponseList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GetResourcePoliciesResponseList": {
                return Optional.ofNullable(clazz.cast(this.getResourcePoliciesResponseList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetResourcePoliciesResponse, T> g) {
        return obj -> g.apply((GetResourcePoliciesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private List<GluePolicy> getResourcePoliciesResponseList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourcePoliciesResponse model) {
            super(model);
            this.getResourcePoliciesResponseList(model.getResourcePoliciesResponseList);
            this.nextToken(model.nextToken);
        }

        public final Collection<GluePolicy.Builder> getGetResourcePoliciesResponseList() {
            if (this.getResourcePoliciesResponseList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.getResourcePoliciesResponseList != null ? (Collection)this.getResourcePoliciesResponseList.stream().map(GluePolicy::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder getResourcePoliciesResponseList(Collection<GluePolicy> getResourcePoliciesResponseList) {
            this.getResourcePoliciesResponseList = GetResourcePoliciesResponseListCopier.copy(getResourcePoliciesResponseList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder getResourcePoliciesResponseList(GluePolicy ... getResourcePoliciesResponseList) {
            this.getResourcePoliciesResponseList(Arrays.asList(getResourcePoliciesResponseList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder getResourcePoliciesResponseList(Consumer<GluePolicy.Builder> ... getResourcePoliciesResponseList) {
            this.getResourcePoliciesResponseList(Stream.of(getResourcePoliciesResponseList).map(c -> (GluePolicy)((GluePolicy.Builder)GluePolicy.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGetResourcePoliciesResponseList(Collection<GluePolicy.BuilderImpl> getResourcePoliciesResponseList) {
            this.getResourcePoliciesResponseList = GetResourcePoliciesResponseListCopier.copyFromBuilder(getResourcePoliciesResponseList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetResourcePoliciesResponse build() {
            return new GetResourcePoliciesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetResourcePoliciesResponse> {
        public Builder getResourcePoliciesResponseList(Collection<GluePolicy> var1);

        public Builder getResourcePoliciesResponseList(GluePolicy ... var1);

        public Builder getResourcePoliciesResponseList(Consumer<GluePolicy.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

