/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.DevEndpoint;
import software.amazon.awssdk.services.glue.model.DevEndpointListCopier;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDevEndpointsResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, GetDevEndpointsResponse> {
    private static final SdkField<List<DevEndpoint>> DEV_ENDPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DevEndpoints").getter(GetDevEndpointsResponse.getter(GetDevEndpointsResponse::devEndpoints)).setter(GetDevEndpointsResponse.setter(Builder::devEndpoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DevEndpoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DevEndpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetDevEndpointsResponse.getter(GetDevEndpointsResponse::nextToken)).setter(GetDevEndpointsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEV_ENDPOINTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<DevEndpoint> devEndpoints;
    private final String nextToken;

    private GetDevEndpointsResponse(BuilderImpl builder) {
        super(builder);
        this.devEndpoints = builder.devEndpoints;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasDevEndpoints() {
        return this.devEndpoints != null && !(this.devEndpoints instanceof SdkAutoConstructList);
    }

    public final List<DevEndpoint> devEndpoints() {
        return this.devEndpoints;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDevEndpoints() ? this.devEndpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDevEndpointsResponse)) {
            return false;
        }
        GetDevEndpointsResponse other = (GetDevEndpointsResponse)((Object)obj);
        return this.hasDevEndpoints() == other.hasDevEndpoints() && Objects.equals(this.devEndpoints(), other.devEndpoints()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetDevEndpointsResponse").add("DevEndpoints", this.hasDevEndpoints() ? this.devEndpoints() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DevEndpoints": {
                return Optional.ofNullable(clazz.cast(this.devEndpoints()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDevEndpointsResponse, T> g) {
        return obj -> g.apply((GetDevEndpointsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private List<DevEndpoint> devEndpoints = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDevEndpointsResponse model) {
            super(model);
            this.devEndpoints(model.devEndpoints);
            this.nextToken(model.nextToken);
        }

        public final Collection<DevEndpoint.Builder> getDevEndpoints() {
            if (this.devEndpoints instanceof SdkAutoConstructList) {
                return null;
            }
            return this.devEndpoints != null ? (Collection)this.devEndpoints.stream().map(DevEndpoint::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder devEndpoints(Collection<DevEndpoint> devEndpoints) {
            this.devEndpoints = DevEndpointListCopier.copy(devEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder devEndpoints(DevEndpoint ... devEndpoints) {
            this.devEndpoints(Arrays.asList(devEndpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder devEndpoints(Consumer<DevEndpoint.Builder> ... devEndpoints) {
            this.devEndpoints(Stream.of(devEndpoints).map(c -> (DevEndpoint)((DevEndpoint.Builder)DevEndpoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDevEndpoints(Collection<DevEndpoint.BuilderImpl> devEndpoints) {
            this.devEndpoints = DevEndpointListCopier.copyFromBuilder(devEndpoints);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetDevEndpointsResponse build() {
            return new GetDevEndpointsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDevEndpointsResponse> {
        public Builder devEndpoints(Collection<DevEndpoint> var1);

        public Builder devEndpoints(DevEndpoint ... var1);

        public Builder devEndpoints(Consumer<DevEndpoint.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

