/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.services.glue.model.UserDefinedFunction;
import software.amazon.awssdk.services.glue.model.UserDefinedFunctionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetUserDefinedFunctionsResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, GetUserDefinedFunctionsResponse> {
    private static final SdkField<List<UserDefinedFunction>> USER_DEFINED_FUNCTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UserDefinedFunctions").getter(GetUserDefinedFunctionsResponse.getter(GetUserDefinedFunctionsResponse::userDefinedFunctions)).setter(GetUserDefinedFunctionsResponse.setter(Builder::userDefinedFunctions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserDefinedFunctions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UserDefinedFunction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetUserDefinedFunctionsResponse.getter(GetUserDefinedFunctionsResponse::nextToken)).setter(GetUserDefinedFunctionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_DEFINED_FUNCTIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<UserDefinedFunction> userDefinedFunctions;
    private final String nextToken;

    private GetUserDefinedFunctionsResponse(BuilderImpl builder) {
        super(builder);
        this.userDefinedFunctions = builder.userDefinedFunctions;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasUserDefinedFunctions() {
        return this.userDefinedFunctions != null && !(this.userDefinedFunctions instanceof SdkAutoConstructList);
    }

    public final List<UserDefinedFunction> userDefinedFunctions() {
        return this.userDefinedFunctions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserDefinedFunctions() ? this.userDefinedFunctions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUserDefinedFunctionsResponse)) {
            return false;
        }
        GetUserDefinedFunctionsResponse other = (GetUserDefinedFunctionsResponse)((Object)obj);
        return this.hasUserDefinedFunctions() == other.hasUserDefinedFunctions() && Objects.equals(this.userDefinedFunctions(), other.userDefinedFunctions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetUserDefinedFunctionsResponse").add("UserDefinedFunctions", this.hasUserDefinedFunctions() ? this.userDefinedFunctions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserDefinedFunctions": {
                return Optional.ofNullable(clazz.cast(this.userDefinedFunctions()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetUserDefinedFunctionsResponse, T> g) {
        return obj -> g.apply((GetUserDefinedFunctionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private List<UserDefinedFunction> userDefinedFunctions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetUserDefinedFunctionsResponse model) {
            super(model);
            this.userDefinedFunctions(model.userDefinedFunctions);
            this.nextToken(model.nextToken);
        }

        public final Collection<UserDefinedFunction.Builder> getUserDefinedFunctions() {
            if (this.userDefinedFunctions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.userDefinedFunctions != null ? (Collection)this.userDefinedFunctions.stream().map(UserDefinedFunction::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder userDefinedFunctions(Collection<UserDefinedFunction> userDefinedFunctions) {
            this.userDefinedFunctions = UserDefinedFunctionListCopier.copy(userDefinedFunctions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userDefinedFunctions(UserDefinedFunction ... userDefinedFunctions) {
            this.userDefinedFunctions(Arrays.asList(userDefinedFunctions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userDefinedFunctions(Consumer<UserDefinedFunction.Builder> ... userDefinedFunctions) {
            this.userDefinedFunctions(Stream.of(userDefinedFunctions).map(c -> (UserDefinedFunction)((UserDefinedFunction.Builder)UserDefinedFunction.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUserDefinedFunctions(Collection<UserDefinedFunction.BuilderImpl> userDefinedFunctions) {
            this.userDefinedFunctions = UserDefinedFunctionListCopier.copyFromBuilder(userDefinedFunctions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetUserDefinedFunctionsResponse build() {
            return new GetUserDefinedFunctionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetUserDefinedFunctionsResponse> {
        public Builder userDefinedFunctions(Collection<UserDefinedFunction> var1);

        public Builder userDefinedFunctions(UserDefinedFunction ... var1);

        public Builder userDefinedFunctions(Consumer<UserDefinedFunction.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

