/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum BackfillErrorCode {
    ENCRYPTED_PARTITION_ERROR("ENCRYPTED_PARTITION_ERROR"),
    INTERNAL_ERROR("INTERNAL_ERROR"),
    INVALID_PARTITION_TYPE_DATA_ERROR("INVALID_PARTITION_TYPE_DATA_ERROR"),
    MISSING_PARTITION_VALUE_ERROR("MISSING_PARTITION_VALUE_ERROR"),
    UNSUPPORTED_PARTITION_CHARACTER_ERROR("UNSUPPORTED_PARTITION_CHARACTER_ERROR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private BackfillErrorCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BackfillErrorCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(BackfillErrorCode.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BackfillErrorCode> knownValues() {
        return Stream.of(BackfillErrorCode.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

