/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.DeleteBehavior;
import software.amazon.awssdk.services.glue.model.UpdateBehavior;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SchemaChangePolicy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SchemaChangePolicy> {
    private static final SdkField<String> UPDATE_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UpdateBehavior").getter(SchemaChangePolicy.getter(SchemaChangePolicy::updateBehaviorAsString)).setter(SchemaChangePolicy.setter(Builder::updateBehavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateBehavior").build()}).build();
    private static final SdkField<String> DELETE_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeleteBehavior").getter(SchemaChangePolicy.getter(SchemaChangePolicy::deleteBehaviorAsString)).setter(SchemaChangePolicy.setter(Builder::deleteBehavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteBehavior").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UPDATE_BEHAVIOR_FIELD, DELETE_BEHAVIOR_FIELD));
    private static final long serialVersionUID = 1L;
    private final String updateBehavior;
    private final String deleteBehavior;

    private SchemaChangePolicy(BuilderImpl builder) {
        this.updateBehavior = builder.updateBehavior;
        this.deleteBehavior = builder.deleteBehavior;
    }

    public UpdateBehavior updateBehavior() {
        return UpdateBehavior.fromValue(this.updateBehavior);
    }

    public String updateBehaviorAsString() {
        return this.updateBehavior;
    }

    public DeleteBehavior deleteBehavior() {
        return DeleteBehavior.fromValue(this.deleteBehavior);
    }

    public String deleteBehaviorAsString() {
        return this.deleteBehavior;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.updateBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteBehaviorAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SchemaChangePolicy)) {
            return false;
        }
        SchemaChangePolicy other = (SchemaChangePolicy)obj;
        return Objects.equals(this.updateBehaviorAsString(), other.updateBehaviorAsString()) && Objects.equals(this.deleteBehaviorAsString(), other.deleteBehaviorAsString());
    }

    public String toString() {
        return ToString.builder((String)"SchemaChangePolicy").add("UpdateBehavior", (Object)this.updateBehaviorAsString()).add("DeleteBehavior", (Object)this.deleteBehaviorAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UpdateBehavior": {
                return Optional.ofNullable(clazz.cast(this.updateBehaviorAsString()));
            }
            case "DeleteBehavior": {
                return Optional.ofNullable(clazz.cast(this.deleteBehaviorAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SchemaChangePolicy, T> g) {
        return obj -> g.apply((SchemaChangePolicy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String updateBehavior;
        private String deleteBehavior;

        private BuilderImpl() {
        }

        private BuilderImpl(SchemaChangePolicy model) {
            this.updateBehavior(model.updateBehavior);
            this.deleteBehavior(model.deleteBehavior);
        }

        public final String getUpdateBehavior() {
            return this.updateBehavior;
        }

        @Override
        public final Builder updateBehavior(String updateBehavior) {
            this.updateBehavior = updateBehavior;
            return this;
        }

        @Override
        public final Builder updateBehavior(UpdateBehavior updateBehavior) {
            this.updateBehavior(updateBehavior == null ? null : updateBehavior.toString());
            return this;
        }

        public final void setUpdateBehavior(String updateBehavior) {
            this.updateBehavior = updateBehavior;
        }

        public final String getDeleteBehavior() {
            return this.deleteBehavior;
        }

        @Override
        public final Builder deleteBehavior(String deleteBehavior) {
            this.deleteBehavior = deleteBehavior;
            return this;
        }

        @Override
        public final Builder deleteBehavior(DeleteBehavior deleteBehavior) {
            this.deleteBehavior(deleteBehavior == null ? null : deleteBehavior.toString());
            return this;
        }

        public final void setDeleteBehavior(String deleteBehavior) {
            this.deleteBehavior = deleteBehavior;
        }

        public SchemaChangePolicy build() {
            return new SchemaChangePolicy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SchemaChangePolicy> {
        public Builder updateBehavior(String var1);

        public Builder updateBehavior(UpdateBehavior var1);

        public Builder deleteBehavior(String var1);

        public Builder deleteBehavior(DeleteBehavior var1);
    }
}

