/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Order
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Order> {
    private static final SdkField<String> COLUMN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Column").getter(Order.getter(Order::column)).setter(Order.setter(Builder::column)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Column").build()}).build();
    private static final SdkField<Integer> SORT_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SortOrder").getter(Order.getter(Order::sortOrder)).setter(Order.setter(Builder::sortOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortOrder").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_FIELD, SORT_ORDER_FIELD));
    private static final long serialVersionUID = 1L;
    private final String column;
    private final Integer sortOrder;

    private Order(BuilderImpl builder) {
        this.column = builder.column;
        this.sortOrder = builder.sortOrder;
    }

    public String column() {
        return this.column;
    }

    public Integer sortOrder() {
        return this.sortOrder;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.column());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortOrder());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Order)) {
            return false;
        }
        Order other = (Order)obj;
        return Objects.equals(this.column(), other.column()) && Objects.equals(this.sortOrder(), other.sortOrder());
    }

    public String toString() {
        return ToString.builder((String)"Order").add("Column", (Object)this.column()).add("SortOrder", (Object)this.sortOrder()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Column": {
                return Optional.ofNullable(clazz.cast(this.column()));
            }
            case "SortOrder": {
                return Optional.ofNullable(clazz.cast(this.sortOrder()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Order, T> g) {
        return obj -> g.apply((Order)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String column;
        private Integer sortOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(Order model) {
            this.column(model.column);
            this.sortOrder(model.sortOrder);
        }

        public final String getColumn() {
            return this.column;
        }

        @Override
        public final Builder column(String column) {
            this.column = column;
            return this;
        }

        public final void setColumn(String column) {
            this.column = column;
        }

        public final Integer getSortOrder() {
            return this.sortOrder;
        }

        @Override
        public final Builder sortOrder(Integer sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public final void setSortOrder(Integer sortOrder) {
            this.sortOrder = sortOrder;
        }

        public Order build() {
            return new Order(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Order> {
        public Builder column(String var1);

        public Builder sortOrder(Integer var1);
    }
}

