/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum TaskStatusType {
    STARTING("STARTING"),
    RUNNING("RUNNING"),
    STOPPING("STOPPING"),
    STOPPED("STOPPED"),
    SUCCEEDED("SUCCEEDED"),
    FAILED("FAILED"),
    TIMEOUT("TIMEOUT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private TaskStatusType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TaskStatusType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(TaskStatusType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TaskStatusType> knownValues() {
        return Stream.of(TaskStatusType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

